/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.teams;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;

public final class TeamAPI {
    private TeamAPI() {
    }

    @Nullable
    public static ITeam getTeam(boolean isClient, long teamID) {
        return TeamSaveData.GetTeam(isClient, teamID);
    }

    @Nonnull
    public static List<? extends ITeam> getAllTeams(boolean isClient) {
        return TeamSaveData.GetAllTeams(isClient);
    }

    @Nonnull
    public static List<ITeam> getAllTeamsForPlayer(@Nonnull Player player) {
        ArrayList<ITeam> result = new ArrayList<ITeam>();
        List<? extends ITeam> allTeams = TeamAPI.getAllTeams(player.f_19853_.f_46443_);
        for (ITeam iTeam : allTeams) {
            if (!iTeam.isMember(player)) continue;
            result.add(iTeam);
        }
        result.sort(TeamAPI.sorterFor(player));
        return ImmutableList.copyOf(result);
    }

    @Nonnull
    public static ITeam createTeam(@Nonnull Player owner, @Nonnull String name) {
        if (owner.f_19853_.f_46443_) {
            return null;
        }
        return TeamSaveData.RegisterTeam(owner, name);
    }

    @Nonnull
    public static Comparator<ITeam> sorterFor(@Nonnull Player player) {
        return Team.sorterFor(player);
    }
}

