/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.teams;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;

public interface ITeam {
    public long getID();

    @Nonnull
    public String getName();

    @Nonnull
    public PlayerReference getOwner();

    @Nonnull
    public List<PlayerReference> getAdmins();

    @Nonnull
    public List<PlayerReference> getMembers();

    @Nonnull
    default public List<PlayerReference> getAdminsAndOwner() {
        ArrayList<PlayerReference> result = new ArrayList<PlayerReference>(this.getAdmins());
        result.add(this.getOwner());
        return ImmutableList.copyOf(result);
    }

    @Nonnull
    default public List<PlayerReference> getAllMembers() {
        ArrayList<PlayerReference> result = new ArrayList<PlayerReference>();
        result.addAll(this.getMembers());
        result.addAll(this.getAdmins());
        result.add(this.getOwner());
        return ImmutableList.copyOf(result);
    }

    public boolean hasBankAccount();

    public boolean canAccessBankAccount(@Nonnull Player var1);

    @Nullable
    public IBankAccount getBankAccount();

    public boolean isOwner(@Nonnull Player var1);

    default public boolean isOwner(@Nonnull PlayerReference player) {
        return this.isOwner(player.id);
    }

    public boolean isOwner(@Nonnull UUID var1);

    public boolean isAdmin(@Nonnull Player var1);

    default public boolean isAdmin(@Nonnull PlayerReference player) {
        return this.isAdmin(player.id);
    }

    public boolean isAdmin(@Nonnull UUID var1);

    public boolean isMember(@Nonnull Player var1);

    default public boolean isMember(@Nonnull PlayerReference player) {
        return this.isMember(player.id);
    }

    public boolean isMember(@Nonnull UUID var1);
}

