/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.notifications;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.events.NotificationEvent;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketSyncNotifications;
import io.github.lightman314.lightmanscurrency.network.message.notifications.SPacketChatNotification;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="lightmanscurrency")
public class NotificationSaveData
extends SavedData {
    private final Map<UUID, NotificationData> playerNotifications = new HashMap<UUID, NotificationData>();

    private NotificationSaveData() {
    }

    private NotificationSaveData(CompoundTag compound) {
        ListTag notificationData = compound.m_128437_("PlayerNotifications", 10);
        for (int i = 0; i < notificationData.size(); ++i) {
            CompoundTag tag = notificationData.m_128728_(i);
            UUID id = tag.m_128342_("Player");
            NotificationData data = NotificationData.loadFrom(tag);
            if (id == null || data == null) continue;
            this.playerNotifications.put(id, data);
        }
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag notificationData = new ListTag();
        this.playerNotifications.forEach((id, data) -> {
            CompoundTag tag = data.save();
            tag.m_128362_("Player", id);
            notificationData.add((Object)tag);
        });
        compound.m_128365_("PlayerNotifications", (Tag)notificationData);
        return compound;
    }

    private static NotificationSaveData get() {
        ServerLevel level;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (level = server.m_129880_(Level.f_46428_)) != null) {
            return (NotificationSaveData)level.m_8895_().m_164861_(NotificationSaveData::new, NotificationSaveData::new, "lightmanscurrency_notification_data");
        }
        return null;
    }

    public static NotificationData GetNotifications(Player player) {
        return player == null ? new NotificationData() : NotificationSaveData.GetNotifications(player.m_20148_());
    }

    public static NotificationData GetNotifications(UUID playerID) {
        if (playerID == null) {
            return new NotificationData();
        }
        NotificationSaveData nsd = NotificationSaveData.get();
        if (nsd != null) {
            if (!nsd.playerNotifications.containsKey(playerID)) {
                nsd.playerNotifications.put(playerID, new NotificationData());
                nsd.m_77762_();
            }
            return nsd.playerNotifications.get(playerID);
        }
        return new NotificationData();
    }

    public static void MarkNotificationsDirty(UUID playerID) {
        NotificationSaveData nsd = NotificationSaveData.get();
        if (nsd != null) {
            ServerPlayer player;
            nsd.m_77762_();
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && (player = server.m_6846_().m_11259_(playerID)) != null) {
                new SPacketSyncNotifications(NotificationSaveData.GetNotifications(playerID)).sendTo(player);
            }
        }
    }

    public static void PushNotification(UUID playerID, Notification notification) {
        NotificationSaveData.PushNotification(playerID, notification, true);
    }

    public static void PushNotification(UUID playerID, Notification notification, boolean pushToChat) {
        if (notification == null) {
            LightmansCurrency.LogError("Cannot push a null notification!");
            return;
        }
        NotificationData data = NotificationSaveData.GetNotifications(playerID);
        if (data != null) {
            ServerPlayer player;
            MinecraftServer server;
            NotificationEvent.NotificationSent.Pre event = new NotificationEvent.NotificationSent.Pre(playerID, data, notification);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            data.addNotification(event.getNotification());
            NotificationSaveData.MarkNotificationsDirty(playerID);
            MinecraftForge.EVENT_BUS.post((Event)new NotificationEvent.NotificationSent.Post(playerID, data, event.getNotification()));
            if (pushToChat && (server = ServerLifecycleHooks.getCurrentServer()) != null && (player = server.m_6846_().m_11259_(playerID)) != null) {
                new SPacketChatNotification(notification).sendTo(player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void OnPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        NotificationData notifications = NotificationSaveData.GetNotifications(event.getEntity());
        new SPacketSyncNotifications(notifications).sendTo(event.getEntity());
    }
}

