/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.notifications;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class Notification {
    private long timeStamp = TimeUtil.getCurrentTime();
    private boolean seen = false;
    private int count = 1;

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public final boolean hasTimeStamp() {
        return this.getTimeStamp() > 0L;
    }

    public boolean wasSeen() {
        return this.seen;
    }

    public void setSeen() {
        this.seen = true;
    }

    public int getCount() {
        return this.count;
    }

    protected Notification() {
    }

    @Nonnull
    protected abstract NotificationType<?> getType();

    @Nonnull
    public abstract NotificationCategory getCategory();

    @Nonnull
    public abstract MutableComponent getMessage();

    @Nonnull
    public MutableComponent getGeneralMessage() {
        return EasyText.translatable("notifications.source.general.format", this.getCategory().getName(), this.getMessage());
    }

    @Nonnull
    public MutableComponent getChatMessage() {
        return EasyText.translatable("notifications.chat.format", EasyText.translatable("notifications.chat.format.title", this.getCategory().getName()).m_130940_(ChatFormatting.GOLD), this.getMessage());
    }

    @Nonnull
    public Component getTimeStampMessage() {
        return EasyText.translatable("notifications.timestamp", TimeUtil.formatTime(this.timeStamp));
    }

    @Nonnull
    public final CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        if (this.seen) {
            compound.m_128379_("Seen", true);
        }
        compound.m_128405_("Count", this.count);
        compound.m_128359_("Type", this.getType().type.toString());
        if (this.timeStamp > 0L) {
            compound.m_128356_("TimeStamp", this.timeStamp);
        }
        this.saveAdditional(compound);
        return compound;
    }

    protected abstract void saveAdditional(@Nonnull CompoundTag var1);

    public final void load(@Nonnull CompoundTag compound) {
        if (compound.m_128441_("Seen")) {
            this.seen = true;
        }
        if (compound.m_128425_("Count", 3)) {
            this.count = compound.m_128451_("Count");
        }
        this.timeStamp = compound.m_128425_("TimeStamp", 4) ? compound.m_128454_("TimeStamp") : 0L;
        this.loadAdditional(compound);
    }

    protected abstract void loadAdditional(@Nonnull CompoundTag var1);

    public boolean onNewNotification(@Nonnull Notification other) {
        if (this.canMerge(other)) {
            ++this.count;
            this.seen = false;
            this.timeStamp = TimeUtil.getCurrentTime();
            return true;
        }
        return false;
    }

    protected abstract boolean canMerge(@Nonnull Notification var1);
}

