/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.value;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.types.CurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;

public abstract class MoneyValueParser {
    public final String prefix;
    public static final CommandExceptionType EXCEPTION_TYPE = new CommandExceptionType(){

        public int hashCode() {
            return super.hashCode();
        }
    };

    protected MoneyValueParser(@Nonnull String prefix) {
        this.prefix = prefix;
    }

    protected boolean tryParse(@Nullable String prefix) {
        return this.prefix.equals(prefix);
    }

    protected abstract MoneyValue parseValueArgument(@Nonnull StringReader var1) throws CommandSyntaxException;

    @Nullable
    protected final String tryWrite(@Nonnull MoneyValue value) {
        String sub = this.writeValueArgument(value);
        if (sub != null) {
            return this.prefix + ";" + sub;
        }
        return null;
    }

    protected abstract String writeValueArgument(@Nonnull MoneyValue var1);

    @Nonnull
    public <S> CompletableFuture<Suggestions> listSuggestions(@Nonnull CommandContext<S> context, @Nonnull SuggestionsBuilder builder, @Nonnull String trail, @Nonnull HolderLookup<Item> items) {
        return Suggestions.empty();
    }

    public void addExamples(@Nonnull List<String> examples) {
    }

    @Nonnull
    public static MoneyValue ParseConfigString(String string, Supplier<MoneyValue> defaultValue) {
        try {
            return MoneyValueParser.parse(new StringReader(string), true);
        }
        catch (CommandSyntaxException exception) {
            LightmansCurrency.LogError("Error parsing Money Value config input.", new Object[]{exception});
            return defaultValue.get();
        }
    }

    @Nonnull
    public static MoneyValue parse(StringReader reader, boolean allowEmpty) throws CommandSyntaxException {
        StringReader inputReader = new StringReader(MoneyValueParser.readStringUntil(reader, ' '));
        String prefix = inputReader.getString().contains(";") ? MoneyValueParser.readStringUntil(inputReader, ';') : null;
        for (CurrencyType type : MoneyAPI.API.AllCurrencyTypes()) {
            StringReader readerCopy;
            MoneyValue value;
            MoneyValueParser parser = type.getValueParser();
            if (parser == null || !parser.tryParse(prefix) || (value = parser.parseValueArgument(readerCopy = new StringReader(inputReader))) == null) continue;
            if (allowEmpty) {
                return value;
            }
            if (value.isEmpty() || value.isFree()) {
                throw MoneyValueParser.NoValueException(reader);
            }
            return value;
        }
        throw MoneyValueParser.NoValueException(inputReader);
    }

    @Nonnull
    public static String writeParsable(@Nonnull MoneyValue value) {
        for (CurrencyType type : MoneyAPI.API.AllCurrencyTypes()) {
            String result;
            MoneyValueParser parser = type.getValueParser();
            if (parser == null || (result = parser.tryWrite(value)) == null) continue;
            return result;
        }
        return "ERROR";
    }

    public static String readStringUntil(StringReader reader, char ... t) throws CommandSyntaxException {
        ArrayList<Character> terminators = new ArrayList<Character>();
        for (char c : t) {
            terminators.add(Character.valueOf(c));
        }
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        while (reader.canRead()) {
            char c = reader.read();
            if (escaped) {
                if (terminators.contains(Character.valueOf(c)) || c == '\\') {
                    result.append(c);
                    escaped = false;
                    continue;
                }
                reader.setCursor(reader.getCursor() - 1);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidEscape().createWithContext((ImmutableStringReader)reader, (Object)String.valueOf(c));
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (terminators.contains(Character.valueOf(c))) {
                return result.toString();
            }
            result.append(c);
        }
        return result.toString();
    }

    public static CommandSyntaxException NoValueException(StringReader reader) {
        return new CommandSyntaxException(EXCEPTION_TYPE, (Message)EasyText.translatable("command.argument.coinvalue.novalue", new Object[0]), reader.getString(), reader.getCursor());
    }
}

