/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.value;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.MoneyHolder;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public final class MoneyStorage
extends MoneyHolder {
    private final Map<String, MoneyValue> values = new HashMap<String, MoneyValue>();
    private final Runnable markDirty;
    private final int priority;
    private boolean cacheChanged = true;

    public MoneyStorage(@Nonnull Runnable markDirty) {
        this(markDirty, 0);
    }

    public MoneyStorage(@Nonnull Runnable markDirty, int priority) {
        this.markDirty = Objects.requireNonNull(markDirty);
        this.priority = priority;
    }

    private void markDirty() {
        this.cacheChanged = true;
        this.markDirty.run();
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Nonnull
    public List<MoneyValue> allValues() {
        return ImmutableList.copyOf(this.values.values());
    }

    @Nonnull
    public MoneyValue valueOf(@Nonnull String uniqueName) {
        return this.values.getOrDefault(uniqueName, MoneyValue.empty());
    }

    @Override
    @Nonnull
    public MoneyValue insertMoney(@Nonnull MoneyValue insertAmount, boolean simulation) {
        if (!simulation) {
            this.addValue(insertAmount);
        }
        return MoneyValue.empty();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addValue(@Nonnull MoneyValue value) {
        if (value.isEmpty() || value.isFree()) {
            return;
        }
        String name = value.getUniqueName();
        if (this.values.containsKey(name) && !this.values.get(name).isInvalid()) {
            MoneyValue oldValue = this.values.get(name);
            MoneyValue addedValue = oldValue.addValue(value);
            if (addedValue == null) {
                LightmansCurrency.LogError("Error adding money values of type '" + oldValue.getType() + "' and '" + value.getType() + "' together.");
                return;
            }
            this.values.put(name, addedValue);
        } else {
            this.values.put(name, value);
        }
        this.markDirty();
    }

    public void addValues(@Nonnull Collection<MoneyValue> values) {
        for (MoneyValue val : values) {
            if (val == null) continue;
            this.addValue(val);
        }
    }

    public boolean containsValue(@Nonnull MoneyValue value) {
        return this.valueOf(value.getUniqueName()).containsValue(value);
    }

    @Nonnull
    public MoneyValue capValue(@Nonnull MoneyValue value) {
        return this.containsValue(value) ? value : this.valueOf(value.getUniqueName());
    }

    public boolean isEmpty() {
        return this.values.isEmpty() || this.values.values().stream().allMatch(MoneyValue::isEmpty);
    }

    public void removeValue(@Nonnull MoneyValue value) {
        if (value.isFree() || value.isEmpty()) {
            return;
        }
        if (!this.containsValue(value)) {
            throw new IllegalArgumentException("Cannot remove more money than is stored in the holder!");
        }
        String name = value.getUniqueName();
        MoneyValue oldValue = this.values.get(name);
        MoneyValue newValue = oldValue.subtractValue(value);
        if (newValue == null) {
            LightmansCurrency.LogError("Error subtracting money values of type '" + oldValue.getType() + "' and '" + value.getType() + "' together.");
            return;
        }
        if (newValue.isEmpty() || newValue.isFree()) {
            this.values.remove(name);
        } else {
            this.values.put(name, newValue);
        }
        this.markDirty();
    }

    @Override
    @Nonnull
    public MoneyValue extractMoney(@Nonnull MoneyValue extractAmount, boolean simulation) {
        MoneyValue actualRemoved = this.capValue(extractAmount);
        if (!simulation) {
            this.removeValue(actualRemoved);
        }
        return extractAmount.subtractValue(actualRemoved);
    }

    @Override
    public boolean isMoneyTypeValid(@Nonnull MoneyValue value) {
        return true;
    }

    @Nonnull
    public ListTag save() {
        ListTag list = new ListTag();
        this.values.forEach((key, value) -> {
            if (!value.isEmpty()) {
                list.add((Object)value.save());
            }
        });
        return list;
    }

    public void load(@Nonnull ListTag list) {
        this.values.clear();
        for (int i = 0; i < list.size(); ++i) {
            MoneyValue value = MoneyValue.load(list.m_128728_(i));
            this.values.put(value.getUniqueName(), value);
        }
        this.cacheChanged = true;
    }

    public void safeLoad(@Nonnull CompoundTag tag, @Nonnull String tagName) {
        if (tag.m_128425_(tagName, 9)) {
            this.load(tag.m_128437_(tagName, 10));
        } else {
            this.values.clear();
            MoneyValue value = MoneyValue.safeLoad(tag, tagName);
            if (value != null && !value.isEmpty() && !value.isFree()) {
                this.values.put(value.getUniqueName(), value);
            }
        }
    }

    public void clear() {
        this.values.clear();
        this.markDirty();
    }

    @Nonnull
    public Component getRandomValueText() {
        return this.getRandomValueText((Component)EasyText.translatable("gui.lightmanscurrency.bank.balance.empty", new Object[0]));
    }

    @Nonnull
    public Component getRandomValueText(@Nonnull String emptyText) {
        return this.getRandomValueText((Component)EasyText.literal(emptyText));
    }

    @Nonnull
    public Component getRandomValueText(@Nonnull Component emptyText) {
        if (this.values.isEmpty()) {
            return emptyText;
        }
        List<MoneyValue> values = this.values.values().stream().toList();
        int displayIndex = (int)(TimeUtil.getCurrentTime() / 2000L % (long)values.size());
        return values.get(displayIndex).getText();
    }

    public Component getAllValueText() {
        MutableComponent text = EasyText.empty();
        for (MoneyValue value : this.values.values()) {
            if (value.isEmpty()) continue;
            if (!text.getString().isEmpty()) {
                text.m_7220_((Component)EasyText.translatable("gui.lightmanscurrency.trading.listseperator", new Object[0]));
            }
            text.m_7220_((Component)value.getText());
        }
        return text;
    }

    @Override
    protected void collectStoredMoney(@Nonnull MoneyView.Builder builder) {
        for (MoneyValue value : this.values.values()) {
            builder.add(value);
        }
    }

    @Override
    public boolean hasStoredMoneyChanged() {
        return this.cacheChanged;
    }

    @Override
    public Component getTooltipTitle() {
        return EasyText.translatable("tooltip.lightmanscurrency.trader.info.money.coin_storage", new Object[0]);
    }

    public void GiveToPlayer(@Nonnull Player player) {
        IMoneyHolder handler = MoneyAPI.API.GetPlayersMoneyHandler(player);
        ArrayList<MoneyValue> extra = new ArrayList<MoneyValue>();
        for (MoneyValue value : this.allValues()) {
            MoneyValue e = handler.insertMoney(value, false);
            if (e.isEmpty()) continue;
            extra.add(e);
        }
        this.clear();
        for (MoneyValue e : extra) {
            this.addValue(e);
        }
    }
}

