/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.types.builtin.coins;

import io.github.lightman314.lightmanscurrency.api.capability.money.MoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.CoinEntry;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class CoinContainerMoneyHandler
extends MoneyHandler {
    private final Container container;
    private Container containerCache = new SimpleContainer(1);
    private final Consumer<ItemStack> overflowHandler;

    public CoinContainerMoneyHandler(@Nonnull Container container, @Nonnull Consumer<ItemStack> overflowHandler) {
        this.container = container;
        this.overflowHandler = overflowHandler;
    }

    @Override
    @Nonnull
    public MoneyValue insertMoney(@Nonnull MoneyValue insertAmount, boolean simulation) {
        if (insertAmount instanceof CoinValue) {
            CoinValue coinValue = (CoinValue)insertAmount;
            Container active = simulation ? InventoryUtil.copyInventory(this.container) : this.container;
            List<ItemStack> coins = coinValue.getAsSeperatedItemList();
            ArrayList<ItemStack> extra = new ArrayList<ItemStack>();
            for (ItemStack c : coins) {
                ItemStack e = InventoryUtil.TryPutItemStack(active, c);
                if (e.m_41619_()) continue;
                extra.add(e);
            }
            if (!simulation) {
                for (ItemStack e : extra) {
                    this.overflowHandler.accept(e);
                }
            }
            return MoneyValue.empty();
        }
        return insertAmount;
    }

    @Override
    @Nonnull
    public MoneyValue extractMoney(@Nonnull MoneyValue extractAmount, boolean simulation) {
        if (extractAmount instanceof CoinValue) {
            CoinValue coinValue = (CoinValue)extractAmount;
            Container active = simulation ? InventoryUtil.copyInventory(this.container) : this.container;
            long change = CoinContainerMoneyHandler.takeObjectsOfValue(coinValue, active);
            if (change > 0L) {
                return CoinValue.fromNumber(coinValue.getChain(), change);
            }
            if (change < 0L) {
                this.insertMoney(CoinValue.fromNumber(coinValue.getChain(), change * -1L), simulation);
            }
            return MoneyValue.empty();
        }
        return extractAmount;
    }

    @Override
    public boolean isMoneyTypeValid(@Nonnull MoneyValue value) {
        return value instanceof CoinValue;
    }

    @Override
    protected boolean hasStoredMoneyChanged() {
        return !InventoryUtil.ContainerMatches(this.container, this.containerCache);
    }

    @Override
    protected void collectStoredMoney(@Nonnull MoneyView.Builder builder) {
        CoinContainerMoneyHandler.queryContainerContents(this.container, builder);
        this.containerCache = InventoryUtil.copyInventory(this.container);
    }

    public static void queryContainerContents(@Nonnull Container container, @Nonnull MoneyView.Builder builder) {
        for (ChainData chain : CoinAPI.API.AllChainData()) {
            long totalValue = 0L;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                totalValue += chain.getCoreValue(stack) * (long)stack.m_41613_();
            }
            if (totalValue <= 0L) continue;
            builder.add(CoinValue.fromNumber(chain.chain, totalValue));
        }
    }

    private static long takeObjectsOfValue(@Nonnull CoinValue valueToTake, @Nonnull Container container) {
        ItemStack itemStack;
        int i;
        long coinValue;
        long value = valueToTake.getCoreValue();
        ChainData chainData = CoinAPI.API.ChainData(valueToTake.getChain());
        if (chainData == null) {
            return value;
        }
        List<CoinEntry> coinList = chainData.getAllEntries(true);
        coinList.sort(ChainData.SORT_HIGHEST_VALUE_FIRST);
        for (CoinEntry coinEntry : coinList) {
            coinValue = coinEntry.getCoreValue();
            if (coinValue > value) continue;
            for (i = 0; i < container.m_6643_() && coinValue <= value; ++i) {
                itemStack = container.m_8020_(i);
                if (!coinEntry.matches(itemStack)) continue;
                while (coinValue <= value && !itemStack.m_41619_()) {
                    value -= coinValue;
                    itemStack.m_41774_(1);
                    if (!itemStack.m_41619_()) continue;
                    container.m_6836_(i, ItemStack.f_41583_);
                }
            }
        }
        if (value > 0L) {
            coinList.sort(ChainData.SORT_LOWEST_VALUE_FIRST);
            for (CoinEntry coinEntry : coinList) {
                coinValue = coinEntry.getCoreValue();
                for (i = 0; i < container.m_6643_() && value > 0L; ++i) {
                    itemStack = container.m_8020_(i);
                    if (!coinEntry.matches(itemStack)) continue;
                    while (value > 0L && !itemStack.m_41619_()) {
                        value -= coinValue;
                        itemStack.m_41774_(1);
                        if (!itemStack.m_41619_()) continue;
                        container.m_6836_(i, ItemStack.f_41583_);
                    }
                }
            }
        }
        return value;
    }
}

