/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.types.builtin;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.types.CurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.types.IPlayerMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValueParser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class NullCurrencyType
extends CurrencyType {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "null");
    public static final NullCurrencyType INSTANCE = new NullCurrencyType();

    private NullCurrencyType() {
        super(TYPE);
    }

    @Override
    @Nonnull
    protected MoneyValue sumValuesInternal(@Nonnull List<MoneyValue> values) {
        return null;
    }

    @Override
    @Nullable
    public IPlayerMoneyHandler createMoneyHandlerForPlayer(@Nonnull Player player) {
        return null;
    }

    @Override
    @Nullable
    public IMoneyHandler createMoneyHandlerForContainer(@Nonnull Container container, @Nonnull Consumer<ItemStack> overflowHandler) {
        return null;
    }

    @Override
    public MoneyValue loadMoneyValue(@Nonnull CompoundTag valueTag) {
        if (valueTag.m_128425_("Free", 1) && valueTag.m_128471_("Free")) {
            return MoneyValue.free();
        }
        return MoneyValue.empty();
    }

    @Override
    public MoneyValue loadMoneyValueJson(@Nonnull JsonObject json) {
        return GsonHelper.m_13855_((JsonObject)json, (String)"Free", (boolean)false) ? MoneyValue.free() : MoneyValue.empty();
    }

    @Override
    @Nonnull
    public MoneyValueParser getValueParser() {
        return DefaultValueParser.INSTANCE;
    }

    @Override
    public List<Object> getInputHandlers(@Nullable Player player) {
        return new ArrayList<Object>();
    }

    private static class DefaultValueParser
    extends MoneyValueParser {
        private static final DefaultValueParser INSTANCE = new DefaultValueParser();

        protected DefaultValueParser() {
            super("null");
        }

        @Override
        protected MoneyValue parseValueArgument(@Nonnull StringReader reader) throws CommandSyntaxException {
            String text = reader.getRemaining();
            if (text.equalsIgnoreCase("free")) {
                return MoneyValue.free();
            }
            if (text.equalsIgnoreCase("empty")) {
                return MoneyValue.empty();
            }
            throw new CommandSyntaxException(MoneyValueParser.EXCEPTION_TYPE, (Message)EasyText.translatable("command.argument.coinvalue.not_free_or_empty", new Object[0]), reader.getString(), reader.getCursor());
        }

        @Override
        protected String writeValueArgument(@Nonnull MoneyValue value) {
            if (value.isFree()) {
                return "free";
            }
            if (value.isEmpty()) {
                return "empty";
            }
            return null;
        }
    }
}

