/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.input.templates;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyInputHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public abstract class SimpleDisplayInput
extends MoneyInputHandler {
    private Component prefix = EasyText.empty();
    private Component postfix = EasyText.empty();
    private EditBox input;

    protected SimpleDisplayInput() {
    }

    protected void setPrefix(@Nonnull String prefix) {
        this.prefix = EasyText.literal(prefix);
    }

    protected void setPrefix(@Nonnull Component prefix) {
        this.prefix = prefix;
    }

    protected void setPostfix(@Nonnull String postfix) {
        this.postfix = EasyText.literal(postfix);
    }

    protected void setPostfix(@Nonnull Component postfix) {
        this.postfix = postfix;
    }

    @Override
    public void initialize(@Nonnull ScreenArea widgetArea) {
        int postfixWidth;
        int prefixWidth = this.getFont().m_92852_((FormattedText)this.prefix);
        if (prefixWidth > 0) {
            prefixWidth += 2;
        }
        if ((postfixWidth = this.getFont().m_92852_((FormattedText)this.postfix)) > 0) {
            postfixWidth += 2;
        }
        if (prefixWidth + postfixWidth > widgetArea.width + 40) {
            LightmansCurrency.LogError("Prefix & Postfix are too long. Cannot setup display!\nPrefix: " + this.prefix.getString() + "\nPostfix: " + this.postfix.getString());
            return;
        }
        this.input = this.addChild(new EditBox(this.getFont(), widgetArea.x + 10 + prefixWidth, widgetArea.y + 22, 156 - prefixWidth - postfixWidth, 20, (Component)EasyText.empty()));
        this.input.m_94151_(this::onValueTextChanges);
        this.input.m_94199_(this.maxLength());
        this.input.m_94153_(TextInputUtil::isPositiveDouble);
        this.onValueChanged(this.currentValue());
    }

    protected int maxLength() {
        return 10;
    }

    @Override
    public void renderTick() {
        if (this.input == null) {
            return;
        }
        this.input.f_93624_ = this.isVisible();
        this.input.f_93623_ = !this.isFree() && !this.isLocked();
    }

    protected Component getErrorText() {
        return EasyText.literal("DISPLAY FORMAT TOO LONG");
    }

    @Override
    protected void renderBG(@Nonnull ScreenArea widgetArea, @Nonnull EasyGuiGraphics gui) {
        super.renderBG(widgetArea, gui);
        if (this.input == null) {
            TextRenderUtil.drawCenteredText(gui, this.getErrorText(), widgetArea.width / 2, widgetArea.height / 2 - 10, 0xFF0000);
            MutableComponent formatText = EasyText.empty().m_7220_(this.prefix).m_7220_((Component)EasyText.literal("###")).m_7220_(this.postfix);
            TextRenderUtil.drawCenteredText(gui, (Component)formatText, widgetArea.width / 2, widgetArea.height / 2, 0xFF0000);
            return;
        }
        if (this.isFree()) {
            this.input.m_94144_("");
        }
        if (!this.prefix.getString().isEmpty()) {
            gui.drawShadowed(this.prefix, widgetArea.pos.offset(10, 28), 0xFFFFFF);
        }
        if (!this.postfix.getString().isEmpty()) {
            int width = gui.font.m_92852_((FormattedText)this.postfix);
            gui.drawShadowed(this.postfix, widgetArea.width - 10 - width, 28, 0xFFFFFF);
        }
    }

    private void onValueTextChanges(@Nonnull String newText) {
        if (this.isFree()) {
            return;
        }
        double valueNumber = TextInputUtil.getDoubleValue(this.input);
        new Thread(() -> {
            MoneyValue newValue = this.getValueFromInput(valueNumber);
            this.changeValue(newValue);
        }).start();
    }

    @Override
    public void onValueChanged(@Nonnull MoneyValue newValue) {
        double valueNumber = 0.0;
        if (newValue.getUniqueName().equals(this.getUniqueName())) {
            valueNumber = this.getTextFromDisplay(newValue);
        }
        String text = valueNumber % 1.0 == 0.0 ? String.valueOf((long)valueNumber) : String.valueOf(valueNumber);
        if (this.input != null) {
            this.input.m_94144_(text);
        }
    }

    @Nonnull
    protected abstract MoneyValue getValueFromInput(double var1);

    protected abstract double getTextFromDisplay(@Nonnull MoneyValue var1);
}

