/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins.display.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.CoinEntry;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.ValueDisplayData;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.ValueDisplaySerializer;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class NumberDisplay
extends ValueDisplayData {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "number");
    public static final ValueDisplaySerializer SERIALIZER = new Serializer();
    private final Component format;
    private final Component wordyFormat;
    private final Item baseItem;
    private CoinEntry baseEntry = null;

    public final Component getFormat() {
        return this.format.m_6881_();
    }

    public final Component getWordyFormat() {
        return this.wordyFormat != null ? this.wordyFormat.m_6881_() : this.getFormat();
    }

    @Nullable
    private CoinEntry getBaseEntry() {
        ChainData parent;
        if (this.baseEntry == null && (parent = this.getParent()) != null) {
            this.baseEntry = parent.findEntry(this.baseItem);
        }
        return this.baseEntry;
    }

    public NumberDisplay(@Nonnull Component format, @Nonnull Item baseItem) {
        this.format = format;
        this.wordyFormat = format;
        this.baseItem = baseItem;
    }

    public NumberDisplay(@Nonnull Component format, @Nullable Component wordyFormat, @Nonnull Item baseItem) {
        this.format = format;
        this.wordyFormat = wordyFormat;
        this.baseItem = baseItem;
    }

    @Override
    @Nonnull
    public ValueDisplaySerializer getSerializer() {
        return SERIALIZER;
    }

    public double getDisplayValue(long coreValue) {
        CoinEntry baseUnit = this.getBaseEntry();
        if (baseUnit == null || baseUnit.getCoreValue() <= 0L) {
            return 0.0;
        }
        return (double)coreValue / (double)baseUnit.getCoreValue();
    }

    private double getDisplayValue(@Nonnull Item item) {
        ChainData parent = this.getParent();
        if (parent == null) {
            return 0.0;
        }
        return this.getDisplayValue(parent.getCoreValue(item));
    }

    private String formatDisplay(double value) {
        return this.format.getString().replace("{value}", this.formatDisplayNumber(value));
    }

    private String formatWordyDisplay(double value) {
        return this.getWordyFormat().getString().replace("{value}", this.formatDisplayNumber(value));
    }

    private String formatDisplayNumber(double value) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(this.getMaxDecimal());
        return df.format(value);
    }

    private int getMaxDecimal() {
        double minFraction = this.getDisplayValue(1L) % 1.0;
        if (minFraction > 0.0) {
            return Double.toString(minFraction).length() - 2;
        }
        return 0;
    }

    @Override
    @Nonnull
    public MutableComponent formatValue(@Nonnull CoinValue value, @Nonnull MutableComponent emptyText) {
        return EasyText.literal(this.formatDisplay(this.getDisplayValue(value.getCoreValue())));
    }

    @Override
    public void formatCoinTooltip(@Nonnull ItemStack stack, @Nonnull List<Component> tooltip) {
        double value = this.getDisplayValue(stack.m_41720_());
        tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.coinworth.value", this.formatWordyDisplay(value)).m_130940_(ChatFormatting.YELLOW));
        if (stack.m_41613_() > 1) {
            tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.coinworth.value.stack", this.formatWordyDisplay(value * (double)stack.m_41613_())).m_130940_(ChatFormatting.YELLOW));
        }
    }

    @Override
    @Nonnull
    public MoneyValue parseDisplayInput(double displayInput) {
        CoinEntry baseUnit = this.getBaseEntry();
        if (baseUnit == null) {
            return MoneyValue.empty();
        }
        long baseCoinValue = baseUnit.getCoreValue();
        double totalValue = displayInput * (double)baseCoinValue;
        long value = (long)totalValue;
        if (totalValue % 1.0 >= 0.5) {
            ++value;
        }
        return CoinValue.fromNumber(this.getChain(), value);
    }

    protected static class Serializer
    extends ValueDisplaySerializer {
        private Component format = null;
        private Component wordyFormat = null;
        private Item baseUnit = null;

        protected Serializer() {
        }

        @Override
        @Nonnull
        public ResourceLocation getType() {
            return TYPE;
        }

        @Override
        public void resetBuilder() {
            this.format = null;
            this.wordyFormat = null;
            this.baseUnit = null;
        }

        @Override
        public void parseAdditional(@Nonnull JsonObject chainJson) {
            this.format = Component.Serializer.m_130691_((JsonElement)chainJson.get("displayFormat"));
            if (chainJson.has("displayFormatWordy")) {
                this.wordyFormat = Component.Serializer.m_130691_((JsonElement)chainJson.get("displayFormatWordy"));
            }
        }

        @Override
        public void parseAdditionalFromCoin(@Nonnull CoinEntry coin, @Nonnull JsonObject coinEntry) {
            if (GsonHelper.m_13855_((JsonObject)coinEntry, (String)"baseUnit", (boolean)false)) {
                if (this.baseUnit != null) {
                    throw new JsonSyntaxException("Cannot have two baseUnit entries!");
                }
                this.baseUnit = coin.getCoin();
            }
        }

        @Override
        public void writeAdditional(@Nonnull ValueDisplayData data, @Nonnull JsonObject chainJson) {
            if (data instanceof NumberDisplay) {
                NumberDisplay display = (NumberDisplay)data;
                chainJson.add("displayFormat", Component.Serializer.m_130716_((Component)display.format));
                if (display.wordyFormat != null) {
                    chainJson.add("displayFormatWordy", Component.Serializer.m_130716_((Component)display.wordyFormat));
                }
            }
        }

        @Override
        public void writeAdditionalToCoin(@Nonnull ValueDisplayData data, @Nonnull CoinEntry coin, @Nonnull JsonObject coinEntry) {
            if (data instanceof NumberDisplay) {
                NumberDisplay display = (NumberDisplay)data;
                if (coin.matches(display.baseItem)) {
                    coinEntry.addProperty("baseUnit", Boolean.valueOf(true));
                }
            }
        }

        @Override
        @Nonnull
        public NumberDisplay build() throws JsonSyntaxException {
            if (this.format == null) {
                throw new JsonSyntaxException("displayFormat entry is missing or cannot be parsed!");
            }
            if (this.baseUnit == null) {
                throw new JsonSyntaxException("No coin entry has the 'baseUnit: true' flag!");
            }
            return new NumberDisplay(this.format, this.wordyFormat, this.baseUnit);
        }
    }
}

