/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins.data.coin;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.CoinEntry;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.MainCoinEntry;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class SideBaseCoinEntry
extends MainCoinEntry {
    public final CoinEntry parentCoin;

    public SideBaseCoinEntry(@Nonnull Item coin, @Nonnull CoinEntry parentCoin, int exchangeRate) {
        super(coin, exchangeRate, true);
        this.parentCoin = parentCoin;
    }

    @Override
    protected void writeAdditional(@Nonnull JsonObject json) {
        super.writeAdditional(json);
        json.addProperty("ParentCoin", ForgeRegistries.ITEMS.getKey((Object)this.parentCoin.getCoin()).toString());
    }

    public static CoinEntry parseSub(@Nonnull JsonObject json, @Nonnull List<CoinEntry> coreChain) {
        Item coin = SideBaseCoinEntry.parseBase(json);
        int exchangeRate = GsonHelper.m_13927_((JsonObject)json, (String)"exchangeRate");
        ResourceLocation itemID = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"ParentCoin"));
        Item parentCoin = (Item)ForgeRegistries.ITEMS.getValue(itemID);
        if (parentCoin == null || parentCoin == Items.f_41852_) {
            throw new JsonSyntaxException(itemID + " is not a valid item!");
        }
        CoinEntry parentEntry = null;
        for (int i = 0; parentEntry == null && i < coreChain.size(); ++i) {
            CoinEntry e = coreChain.get(i);
            if (!e.matches(parentCoin)) continue;
            parentEntry = e;
        }
        if (parentEntry == null) {
            throw new JsonSyntaxException(itemID + " does not match any coins in the core chain!");
        }
        return new SideBaseCoinEntry(coin, parentEntry, exchangeRate);
    }
}

