/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins.atm.data;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.data.ATMData;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.data.ATMExchangeButtonData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.atm.ATMExchangeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public final class ATMPageManager {
    private static String lastSelected = "main";
    private ATMData selectedData = null;
    private final Consumer<Object> addChild;
    private final Consumer<Object> removeChild;
    private final Consumer<String> commandProcessor;
    private final List<ATMData> validData;
    private final List<Object> buttons = new ArrayList<Object>();
    private ScreenPosition corner = ScreenPosition.ZERO;

    private ATMPageManager(@Nonnull Player player, @Nonnull Consumer<Object> addChild, @Nonnull Consumer<Object> removeChild, @Nonnull Consumer<String> commandProcessor) {
        this.addChild = addChild;
        this.removeChild = removeChild;
        this.commandProcessor = commandProcessor;
        HashMap<String, ATMData> mapTemp = new HashMap<String, ATMData>();
        for (ChainData chain : CoinAPI.API.AllChainData()) {
            if (!chain.hasATMData() || !chain.isVisibleTo(player)) continue;
            mapTemp.put(chain.chain, chain.getAtmData());
        }
        this.validData = ImmutableList.copyOf(mapTemp.values());
        if (mapTemp.containsKey(lastSelected)) {
            this.selectedData = (ATMData)mapTemp.get(lastSelected);
        } else if (!this.validData.isEmpty()) {
            this.selectedData = this.validData.get(0);
            lastSelected = this.selectedData.chain.chain;
        }
    }

    public void initialize(@Nonnull ScreenArea screen) {
        this.corner = screen.pos;
        if (this.validData.size() > 1) {
            this.addChild.accept(new DropdownWidget(screen.pos.offset(screen.width - 70, 6), 64, this.validData.indexOf(this.selectedData), this::changeSelection, this.getOptions()));
        }
        this.buttons.clear();
        if (this.selectedData != null) {
            for (ATMExchangeButtonData data : this.selectedData.getExchangeButtons()) {
                this.addButton(data);
            }
        }
    }

    private void addButton(@Nonnull ATMExchangeButtonData data) {
        ATMExchangeButton button = new ATMExchangeButton(this.corner, data, this.commandProcessor);
        this.buttons.add((Object)button);
        this.addChild.accept((Object)button);
    }

    private List<Component> getOptions() {
        ArrayList<Component> text = new ArrayList<Component>();
        for (ATMData data : this.validData) {
            text.add((Component)data.chain.getDisplayName());
        }
        return text;
    }

    public void changeSelection(int newSelection) {
        if (newSelection >= 0 && newSelection < this.validData.size()) {
            ATMData newData = this.validData.get(newSelection);
            if (newData == this.selectedData) {
                return;
            }
            this.selectedData = newData;
            for (Object b : this.buttons) {
                this.removeChild.accept(b);
            }
            this.buttons.clear();
            for (ATMExchangeButtonData data : this.selectedData.getExchangeButtons()) {
                this.addButton(data);
            }
        }
    }

    public static ATMPageManager create(@Nonnull Player player, @Nonnull Consumer<Object> addChild, @Nonnull Consumer<Object> removeChild, @Nonnull Consumer<String> commandProcessor) {
        return new ATMPageManager(player, addChild, removeChild, commandProcessor);
    }
}

