/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.Sprite;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.util.LazyOptional;

public final class EasyGuiGraphics
extends GuiComponent {
    public final Font font;
    private final PoseStack pose;
    private final LazyOptional<Screen> screen;
    public final ScreenPosition mousePos;
    public final float partialTicks;
    private final List<ScreenPosition> offsetStack = new ArrayList<ScreenPosition>();
    private ScreenPosition offset = ScreenPosition.ZERO;

    public PoseStack getPose() {
        return this.pose;
    }

    public EasyGuiGraphics pushOffsetZero() {
        return this.pushOffset(ScreenPosition.ZERO);
    }

    public EasyGuiGraphics pushOffset(@Nonnull ScreenPosition offset) {
        this.offsetStack.add(0, offset);
        return this.refactorOffset();
    }

    public EasyGuiGraphics pushOffset(@Nonnull AbstractWidget widget) {
        this.offsetStack.add(0, ScreenPosition.of(widget.f_93620_, widget.f_93621_));
        return this.refactorOffset();
    }

    public EasyGuiGraphics popOffset() {
        if (this.offsetStack.size() > 0) {
            this.offsetStack.remove(0);
        }
        return this.refactorOffset();
    }

    private EasyGuiGraphics refactorOffset() {
        this.offset = this.offsetStack.size() > 0 ? this.offsetStack.get(0) : ScreenPosition.ZERO;
        return this;
    }

    private EasyGuiGraphics(@Nonnull PoseStack pose, Font font, int mouseX, int mouseY, float partialTicks) {
        this.pose = pose;
        this.font = font;
        this.mousePos = ScreenPosition.of(mouseX, mouseY);
        this.partialTicks = partialTicks;
        Minecraft mc = Minecraft.m_91087_();
        if (mc != null && mc.f_91080_ != null) {
            Screen s = mc.f_91080_;
            this.screen = LazyOptional.of(() -> s);
        } else {
            this.screen = LazyOptional.empty();
        }
    }

    public static EasyGuiGraphics create(@Nonnull PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        return EasyGuiGraphics.create(pose, Minecraft.m_91087_().f_91062_, mouseX, mouseY, partialTicks);
    }

    public static EasyGuiGraphics create(@Nonnull PoseStack pose, Font font, int mouseX, int mouseY, float partialTicks) {
        return new EasyGuiGraphics(pose, font, mouseX, mouseY, partialTicks);
    }

    public static EasyGuiGraphics create(@Nonnull ScreenEvent.Render event) {
        return new EasyGuiGraphics(event.getPoseStack(), event.getScreen().getMinecraft().f_91062_, event.getMouseX(), event.getMouseY(), event.getPartialTick());
    }

    public static EasyGuiGraphics create(@Nonnull ContainerScreenEvent.Render event) {
        return new EasyGuiGraphics(event.getPoseStack(), event.getContainerScreen().getMinecraft().f_91062_, event.getMouseX(), event.getMouseY(), 0.0f);
    }

    public void setColor(float r, float g, float b) {
        this.setColor(r, g, b, 1.0f);
    }

    public void setColor(float r, float g, float b, float a) {
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
    }

    public void resetColor() {
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderNormalBackground(@Nonnull ResourceLocation image, @Nonnull IEasyScreen screen) {
        this.resetColor();
        this.pushOffset(screen.getCorner()).blit(image, 0, 0, 0, 0, screen.getXSize(), screen.getYSize());
        this.popOffset();
    }

    public void blit(@Nonnull ResourceLocation image, int x, int y, int u, int v, int width, int height) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)image);
        this.m_93228_(this.pose, this.offset.x + x, this.offset.y + y, u, v, width, height);
    }

    public void blit(@Nonnull ResourceLocation image, @Nonnull ScreenPosition pos, int u, int v, int width, int height) {
        this.blit(image, pos.x, pos.y, u, v, width, height);
    }

    public void blitSprite(@Nonnull Sprite sprite, int x, int y) {
        this.blitSprite(sprite, x, y, false);
    }

    public void blitSprite(@Nonnull Sprite sprite, @Nonnull ScreenPosition pos) {
        this.blitSprite(sprite, pos.x, pos.y);
    }

    public void blitSprite(@Nonnull Sprite sprite, int x, int y, boolean hovered) {
        this.blit(sprite.image, x, y, sprite.getU(hovered), sprite.getV(hovered), sprite.width, sprite.height);
    }

    public void blitSprite(@Nonnull Sprite sprite, @Nonnull ScreenPosition pos, boolean hovered) {
        this.blitSprite(sprite, pos.x, pos.y, hovered);
    }

    public void blitSpriteFadeHoriz(@Nonnull Sprite sprite, int x, int y, float percent) {
        this.blitSpriteFadeHoriz(sprite, x, y, percent, false);
    }

    public void blitSpriteFadeHoriz(@Nonnull Sprite sprite, @Nonnull ScreenPosition pos, float percent) {
        this.blitSpriteFadeHoriz(sprite, pos.x, pos.y, percent);
    }

    public void blitSpriteFadeHoriz(@Nonnull Sprite sprite, int x, int y, float percent, boolean hovered) {
        int blitWidth = MathUtil.clamp((int)((float)(sprite.width + 1) * percent), 0, sprite.width);
        this.blit(sprite.image, x, y, sprite.getU(hovered), sprite.getV(hovered), blitWidth, sprite.height);
    }

    public void blitSpriteFadeHoriz(@Nonnull Sprite sprite, @Nonnull ScreenPosition pos, float percent, boolean hovered) {
        this.blitSpriteFadeHoriz(sprite, pos.x, pos.y, percent, hovered);
    }

    public void blitBackgroundOfSize(@Nonnull ResourceLocation image, int x, int y, int width, int height, int u, int v, int uWidth, int vHeight, int edge) {
        int widthToDraw;
        int heightToDraw;
        int tempX;
        int widthToDraw2;
        int uCenter = uWidth - edge - edge;
        if (uCenter < 1) {
            throw new IllegalArgumentException("Invalid inputs resulted in uCenter of " + uCenter);
        }
        int vCenter = vHeight - edge - edge;
        if (vCenter < 1) {
            throw new IllegalArgumentException("Invalid inputs resulted in vCenter of " + vCenter);
        }
        this.blit(image, x, y, u, v, edge, edge);
        for (tempX = edge; tempX < width - edge; tempX += widthToDraw2) {
            widthToDraw2 = Math.min(uCenter, width - edge - tempX);
            this.blit(image, x + tempX, y, u + edge, v, widthToDraw2, edge);
        }
        this.blit(image, x + width - edge, y, u + uWidth - edge, v, edge, edge);
        for (int tempY = edge; tempY < height - edge; tempY += heightToDraw) {
            int widthToDraw3;
            heightToDraw = Math.min(vCenter, height - edge - tempY);
            this.blit(image, x, y + tempY, u, v + edge, edge, heightToDraw);
            for (tempX = edge; tempX < width - edge; tempX += widthToDraw3) {
                widthToDraw3 = Math.min(uCenter, width - edge - tempX);
                this.blit(image, x + tempX, y + tempY, u + edge, v + edge, widthToDraw3, heightToDraw);
            }
            this.blit(image, x + width - edge, y + tempY, u + uWidth - edge, v + edge, edge, heightToDraw);
        }
        this.blit(image, x, y + height - edge, u, v + vHeight - edge, edge, edge);
        for (tempX = edge; tempX < width - edge; tempX += widthToDraw) {
            widthToDraw = Math.min(uCenter, width - edge - tempX);
            this.blit(image, x + tempX, y + height - edge, u + edge, v + vHeight - edge, widthToDraw, edge);
        }
        this.blit(image, x + width - edge, y + height - edge, u + uWidth - edge, v + vHeight - edge, edge, edge);
    }

    public void renderButtonBG(int x, int y, int width, int height, float alpha, int textureY) {
        this.setColor(1.0f, 1.0f, 1.0f, alpha);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractWidget.f_93617_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        this.m_93228_(this.pose, this.offset.x + x, this.offset.y + y, 0, 46 + textureY * 20, width / 2, height);
        this.m_93228_(this.pose, this.offset.x + x + width / 2, this.offset.y + y, 200 - width / 2, 46 + textureY * 20, width / 2, height);
        this.resetColor();
    }

    public void fill(int x, int y, int width, int height, int color) {
        EasyGuiGraphics.m_93172_((PoseStack)this.pose, (int)(this.offset.x + x), (int)(this.offset.y + y), (int)(this.offset.x + x + width), (int)(this.offset.y + y + height), (int)color);
    }

    public void fill(ScreenPosition pos, int width, int height, int color) {
        this.fill(pos.x, pos.y, width, height, color);
    }

    public void fill(ScreenArea area, int color) {
        this.fill(area.x, area.y, area.width, area.height, color);
    }

    public void renderTooltip(@Nonnull Component tooltip) {
        this.pushOffset(this.mousePos).renderTooltip(tooltip, 0, 0);
        this.popOffset();
    }

    public void renderTooltip(@Nonnull Component tooltip, int x, int y) {
        this.screen.ifPresent(s -> s.m_96602_(this.pose, tooltip, this.offset.x + x, this.offset.y + y));
    }

    public void renderComponentTooltip(@Nonnull List<Component> tooltip) {
        this.pushOffset(this.mousePos).renderComponentTooltip(tooltip, 0, 0);
        this.popOffset();
    }

    public void renderComponentTooltip(@Nonnull List<Component> tooltip, int x, int y) {
        if (tooltip.size() == 0) {
            return;
        }
        this.screen.ifPresent(s -> s.m_96597_(this.pose, tooltip, this.offset.x + x, this.offset.y + y));
    }

    public void renderTooltip(@Nonnull List<FormattedCharSequence> tooltip) {
        this.pushOffset(this.mousePos).renderTooltip(tooltip, 0, 0);
        this.popOffset();
    }

    public void renderTooltip(@Nonnull List<FormattedCharSequence> tooltip, int x, int y) {
        if (tooltip.size() == 0) {
            return;
        }
        this.screen.ifPresent(s -> s.m_96617_(this.pose, tooltip, this.offset.x + x, this.offset.y + y));
    }

    public void renderTooltip(@Nonnull ItemStack item) {
        this.pushOffset(this.mousePos).renderTooltip(item, 0, 0);
        this.popOffset();
    }

    public void renderTooltip(@Nonnull ItemStack item, int x, int y) {
        this.renderComponentTooltip(EasyScreenHelper.getTooltipFromItem(item), x, y);
    }

    public void drawString(String text, int x, int y, int color) {
        this.font.m_92883_(this.pose, text, (float)(this.offset.x + x), (float)(this.offset.y + y), color);
    }

    public void drawString(String text, ScreenPosition pos, int color) {
        this.drawString(text, pos.x, pos.y, color);
    }

    public void drawString(Component text, int x, int y, int color) {
        this.font.m_92889_(this.pose, text, (float)(this.offset.x + x), (float)(this.offset.y + y), color);
    }

    public void drawString(Component text, ScreenPosition pos, int color) {
        this.drawString(text, pos.x, pos.y, color);
    }

    public void drawString(FormattedCharSequence text, int x, int y, int color) {
        this.font.m_92877_(this.pose, text, (float)(this.offset.x + x), (float)(this.offset.y + y), color);
    }

    public void drawString(FormattedCharSequence text, ScreenPosition pos, int color) {
        this.drawString(text, pos.x, pos.y, color);
    }

    public void drawShadowed(String text, int x, int y, int color) {
        this.font.m_92750_(this.pose, text, (float)(this.offset.x + x), (float)(this.offset.y + y), color);
    }

    public void drawShadowed(String text, ScreenPosition pos, int color) {
        this.drawShadowed(text, pos.x, pos.y, color);
    }

    public void drawShadowed(Component text, int x, int y, int color) {
        this.font.m_92763_(this.pose, text, (float)(this.offset.x + x), (float)(this.offset.y + y), color);
    }

    public void drawShadowed(Component text, ScreenPosition pos, int color) {
        this.drawShadowed(text, pos.x, pos.y, color);
    }

    public void drawShadowed(FormattedCharSequence text, int x, int y, int color) {
        this.font.m_92744_(this.pose, text, (float)(this.offset.x + x), (float)(this.offset.y + y), color);
    }

    public void drawShadowed(FormattedCharSequence text, ScreenPosition pos, int color) {
        this.drawShadowed(text, pos.x, pos.y, color);
    }

    public void drawWordWrap(String text, int x, int y, int columnWidth, int color) {
        this.font.m_92857_((FormattedText)EasyText.literal(text), this.offset.x + x, this.offset.y + y, columnWidth, color);
    }

    public void drawWordWrap(Component text, int x, int y, int columnWidth, int color) {
        this.font.m_92857_((FormattedText)text, this.offset.x + x, this.offset.y + y, columnWidth, color);
    }

    public void renderItem(@Nonnull ItemStack item, int x, int y) {
        this.renderItem(item, x, y, null);
    }

    public void renderItem(@Nonnull ItemStack item, @Nonnull ScreenPosition pos) {
        this.renderItem(item, pos.x, pos.y);
    }

    public void renderItem(@Nonnull ItemStack item, @Nonnull ScreenPosition pos, @Nullable String countTextOverride) {
        this.renderItem(item, pos.x, pos.y, countTextOverride);
    }

    public void renderItem(@Nonnull ItemStack item, int x, int y, @Nullable String countTextOverride) {
        this.resetColor();
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer itemRenderer = mc.m_91291_();
        RenderSystem.m_69482_();
        itemRenderer.m_174253_(item, this.offset.x + x, this.offset.y + y, 0);
        itemRenderer.m_115174_(this.font, item, this.offset.x + x, this.offset.y + y, countTextOverride);
    }

    public void renderSlotBackground(Pair<ResourceLocation, ResourceLocation> background, @Nonnull ScreenPosition pos) {
        this.renderSlotBackground(background, pos.x, pos.y);
    }

    public void renderSlotBackground(Pair<ResourceLocation, ResourceLocation> background, int x, int y) {
        if (background == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)minecraft.m_91258_((ResourceLocation)background.getFirst()).apply((ResourceLocation)background.getSecond());
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
        EasyGuiGraphics.m_93200_((PoseStack)this.pose, (int)(this.offset.x + x), (int)(this.offset.y + y), (int)100, (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
    }

    public void renderSlotHighlight(int x, int y) {
        EasyGuiGraphics.m_168740_((PoseStack)this.pose, (int)(this.offset.x + x), (int)(this.offset.y + y), (int)(this.offset.x + x + 16), (int)(this.offset.y + y + 16), (int)-2130706433, (int)-2130706433, (int)0);
    }

    public void renderSlotHighlight(@Nonnull ScreenPosition pos) {
        this.renderSlotHighlight(pos.x, pos.y);
    }

    public EasyGuiGraphics pushPose() {
        this.pose.m_85836_();
        return this;
    }

    public void TranslateToForeground() {
        this.pose.m_85837_(0.0, 0.0, 250.0);
    }

    public void popPose() {
        this.pose.m_85849_();
    }
}

