/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.events;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class TradeEvent
extends Event {
    private final PlayerReference player;
    private final TradeData trade;
    private final TraderData trader;

    @Nonnull
    public final PlayerReference getPlayerReference() {
        return this.player;
    }

    @Nonnull
    public final TradeData getTrade() {
        return this.trade;
    }

    public final int getTradeIndex() {
        return this.trader.indexOfTrade(this.trade);
    }

    @Nonnull
    public final TraderData getTrader() {
        return this.trader;
    }

    protected TradeEvent(@Nonnull PlayerReference player, @Nonnull TradeData trade, @Nonnull TraderData trader) {
        this.player = player;
        this.trade = trade;
        this.trader = trader;
    }

    public static class PostTradeEvent
    extends TradeEvent {
        private boolean isDirty = false;
        private final MoneyValue pricePaid;
        private final MoneyValue taxesPaid;

        public MoneyValue getPricePaid() {
            return this.pricePaid;
        }

        public MoneyValue getTaxesPaid() {
            return this.taxesPaid;
        }

        public PostTradeEvent(PlayerReference player, TradeData trade, TraderData trader, MoneyValue pricePaid, MoneyValue taxesPaid) {
            super(player, trade, trader);
            this.pricePaid = pricePaid;
            this.taxesPaid = taxesPaid;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public void markDirty() {
            this.isDirty = true;
        }

        public void clean() {
            this.isDirty = false;
        }
    }

    public static class TradeCostEvent
    extends TradeEvent {
        private boolean forceFree = false;
        private int pricePercentage = 100;
        MoneyValue baseCost;

        public boolean forcedFree() {
            return this.forceFree;
        }

        public void makeFree() {
            this.forceFree = true;
        }

        public void makeNotFree() {
            this.forceFree = false;
        }

        public int getPricePercentage() {
            return this.pricePercentage;
        }

        public void setPricePercentage(int pricePercentage) {
            this.pricePercentage = pricePercentage;
        }

        public void giveDiscount(int percentage) {
            this.pricePercentage -= percentage;
        }

        public void hikePrice(int percentage) {
            this.pricePercentage += percentage;
        }

        public MoneyValue getBaseCost() {
            return this.baseCost;
        }

        public boolean getCostResultIsFree() {
            return this.forceFree || this.pricePercentage <= 0;
        }

        public MoneyValue getCostResult() {
            return this.getCostResultIsFree() ? MoneyValue.free() : this.baseCost.percentageOfValue(this.pricePercentage);
        }

        public TradeCostEvent(@Nonnull PlayerReference player, @Nonnull TradeData trade, @Nonnull TraderData trader) {
            super(player, trade, trader);
            this.baseCost = trade.getCost();
        }

        public final boolean matches(@Nonnull TradeData trade) {
            return this.getTrade() == trade;
        }

        public final boolean matches(@Nonnull TradeCostEvent event) {
            return this.getTrade() == event.getTrade() && this.forceFree == event.forceFree && this.pricePercentage == event.pricePercentage && this.baseCost.equals(event.baseCost);
        }
    }

    @Cancelable
    public static class PreTradeEvent
    extends TradeEvent {
        private final List<AlertData> alerts = new ArrayList<AlertData>();

        public PreTradeEvent(@Nonnull PlayerReference player, @Nonnull TradeData trade, @Nonnull TraderData trader) {
            super(player, trade, trader);
        }

        public void addAlert(@Nonnull AlertData alert, boolean cancelTrade) {
            this.alerts.add(alert);
            if (cancelTrade) {
                this.setCanceled(true);
            }
        }

        public void addHelpful(@Nonnull MutableComponent message) {
            this.addAlert(AlertData.helpful(message), false);
        }

        public void addNeutral(@Nonnull MutableComponent message) {
            this.addAlert(AlertData.neutral(message), false);
        }

        public void addWarning(@Nonnull MutableComponent message) {
            this.addAlert(AlertData.warn(message), false);
        }

        public void addError(@Nonnull MutableComponent message) {
            this.addAlert(AlertData.error(message), false);
        }

        public void addDenial(@Nonnull MutableComponent message) {
            this.addAlert(AlertData.error(message), true);
        }

        @Nonnull
        public List<AlertData> getAlertInfo() {
            return this.alerts;
        }
    }
}

