/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.basic;

import io.github.lightman314.lightmanscurrency.api.config.options.ListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.IntOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class IntListOption
extends ListOption<Integer> {
    private final int lowerLimit;
    private final int upperLimit;
    private final ConfigParser<Integer> parser;

    protected IntListOption(@Nonnull NonNullSupplier<List<Integer>> defaultValue, int lowerLimit, int upperLimit) {
        super(defaultValue);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.parser = IntOption.makeParser(lowerLimit, upperLimit);
    }

    @Override
    protected ConfigParser<Integer> getPartialParser() {
        return this.parser;
    }

    @Override
    @Nullable
    protected String bonusComment() {
        return "Range: " + this.lowerLimit + " -> " + this.upperLimit;
    }

    public static IntListOption create(@Nonnull List<Integer> defaultValue) {
        return new IntListOption((NonNullSupplier<List<Integer>>)((NonNullSupplier)() -> defaultValue), Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static IntListOption create(@Nonnull List<Integer> defaultValue, int lowerLimit) {
        return new IntListOption((NonNullSupplier<List<Integer>>)((NonNullSupplier)() -> defaultValue), lowerLimit, Integer.MAX_VALUE);
    }

    public static IntListOption create(@Nonnull List<Integer> defaultValue, int lowerLimit, int upperLimit) {
        return new IntListOption((NonNullSupplier<List<Integer>>)((NonNullSupplier)() -> defaultValue), lowerLimit, upperLimit);
    }

    public static IntListOption create(@Nonnull NonNullSupplier<List<Integer>> defaultValue) {
        return new IntListOption(defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static IntListOption create(@Nonnull NonNullSupplier<List<Integer>> defaultValue, int lowerLimit) {
        return new IntListOption(defaultValue, lowerLimit, Integer.MAX_VALUE);
    }

    public static IntListOption create(@Nonnull NonNullSupplier<List<Integer>> defaultValue, int lowerLimit, int upperLimit) {
        return new IntListOption(defaultValue, lowerLimit, upperLimit);
    }
}

