/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.basic;

import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import javax.annotation.Nonnull;
import net.minecraftforge.common.util.NonNullSupplier;

public class BooleanOption
extends ConfigOption<Boolean> {
    public static final ConfigParser<Boolean> PARSER = new Parser();

    protected BooleanOption(@Nonnull NonNullSupplier<Boolean> defaultValue) {
        super(defaultValue);
    }

    @Override
    @Nonnull
    protected ConfigParser<Boolean> getParser() {
        return PARSER;
    }

    public static BooleanOption createTrue() {
        return BooleanOption.create((NonNullSupplier<Boolean>)((NonNullSupplier)() -> true));
    }

    public static BooleanOption createFalse() {
        return BooleanOption.create((NonNullSupplier<Boolean>)((NonNullSupplier)() -> false));
    }

    public static BooleanOption create(@Nonnull NonNullSupplier<Boolean> defaultValue) {
        return new BooleanOption(defaultValue);
    }

    private static class Parser
    implements ConfigParser<Boolean> {
        private Parser() {
        }

        @Override
        @Nonnull
        public Boolean tryParse(@Nonnull String cleanLine) throws ConfigParsingException {
            return Boolean.parseBoolean(cleanLine);
        }

        @Override
        @Nonnull
        public String write(@Nonnull Boolean value) {
            return Boolean.toString(value);
        }
    }
}

