/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class ListOption<T>
extends ConfigOption<List<T>> {
    protected ListOption(@Nonnull NonNullSupplier<List<T>> defaultValue) {
        super(defaultValue);
    }

    public static <T> ConfigParser<List<T>> makeParser(ConfigParser<T> partialParser) {
        return new ListParser<T>(partialParser);
    }

    @Override
    @Nonnull
    protected ConfigParser<List<T>> getParser() {
        return ListOption.makeParser(this.getPartialParser());
    }

    protected abstract ConfigParser<T> getPartialParser();

    public final Pair<Boolean, ConfigParsingException> editList(String value, int index, boolean isEdit) {
        if (index < 0 && isEdit) {
            try {
                T newValue = this.getPartialParser().tryParse(ListOption.cleanWhitespace(value));
                List currentValue = (List)this.getCurrentValue();
                currentValue.add(newValue);
                this.set(currentValue);
                return Pair.of((Object)true, null);
            }
            catch (ConfigParsingException e) {
                return Pair.of((Object)false, (Object)e);
            }
        }
        if (index >= 0) {
            List currentValue = (List)this.getCurrentValue();
            if (index >= currentValue.size()) {
                return Pair.of((Object)false, (Object)new ConfigParsingException("Invalid index. Maximum is " + (currentValue.size() - 1) + "!"));
            }
            if (isEdit) {
                try {
                    T newValue = this.getPartialParser().tryParse(ListOption.cleanWhitespace(value));
                    currentValue.set(index, newValue);
                    this.set(currentValue);
                    return Pair.of((Object)true, null);
                }
                catch (ConfigParsingException e) {
                    return Pair.of((Object)false, (Object)e);
                }
            }
            currentValue.remove(index);
            this.set(currentValue);
            return Pair.of((Object)true, null);
        }
        return Pair.of((Object)false, (Object)new ConfigParsingException("Invalid edit action. Cannot have an index of " + index + " without the isEdit flag!"));
    }

    private static class ListParser<T>
    implements ConfigParser<List<T>> {
        private final ConfigParser<T> parser;

        private ListParser(@Nonnull ConfigParser<T> parser) {
            this.parser = parser;
        }

        @Override
        @Nonnull
        public List<T> tryParse(@Nonnull String cleanLine) throws ConfigParsingException {
            if (cleanLine.length() == 0) {
                throw new ConfigParsingException("Empty input received!");
            }
            char c1 = cleanLine.charAt(0);
            if (c1 != '[') {
                throw new ConfigParsingException("List does not start with '['!");
            }
            char lastChar = cleanLine.charAt(cleanLine.length() - 1);
            if (lastChar != ']') {
                throw new ConfigParsingException("List does not end with ']'!");
            }
            ArrayList<String> sections = new ArrayList<String>();
            StringBuilder temp = new StringBuilder();
            boolean inQuotes = false;
            boolean escaped = false;
            for (int i = 1; i < cleanLine.length() - 1; ++i) {
                char c = cleanLine.charAt(i);
                if (escaped) {
                    if (c == '\\' || c == '\"') {
                        temp.append(c);
                    } else {
                        temp.append('\\').append(c);
                    }
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == '\"') {
                    inQuotes = !inQuotes;
                    continue;
                }
                if (c == ',') {
                    sections.add(temp.toString());
                    temp = new StringBuilder();
                    continue;
                }
                temp.append(c);
            }
            if (!temp.isEmpty()) {
                sections.add(temp.toString());
            }
            if (sections.size() == 0) {
                return new ArrayList();
            }
            ArrayList<T> results = new ArrayList<T>();
            for (int s = 0; s < sections.size(); ++s) {
                String section = (String)sections.get(s);
                try {
                    results.add(this.parser.tryParse(section));
                    continue;
                }
                catch (ConfigParsingException e) {
                    LightmansCurrency.LogWarning("Failed to parse List Config entry #" + (s + 1), e);
                }
            }
            return results;
        }

        @Override
        @Nonnull
        public String write(@Nonnull List<T> value) {
            StringBuilder builder = new StringBuilder("[");
            boolean comma = false;
            for (T v : value) {
                if (comma) {
                    builder.append(',');
                }
                builder.append(this.parser.write(v));
                comma = true;
            }
            builder.append(']');
            return builder.toString();
        }
    }
}

