/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.capability.money;

import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.MoneyViewer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class MoneyHandler
extends MoneyViewer
implements IMoneyHandler {
    public static IMoneyHandler combine(@Nonnull List<IMoneyHandler> handlers) {
        return new MultiMoneyHandler(handlers);
    }

    private static class MultiMoneyHandler
    extends MoneyHandler {
        private final List<IMoneyHandler> handlers;

        MultiMoneyHandler(@Nonnull List<IMoneyHandler> handlers) {
            this.handlers = handlers;
        }

        @Override
        @Nonnull
        public MoneyValue insertMoney(@Nonnull MoneyValue insertAmount, boolean simulation) {
            for (IMoneyHandler h : this.handlers) {
                if (!h.isMoneyTypeValid(insertAmount) || !(insertAmount = h.insertMoney(insertAmount, simulation)).isEmpty()) continue;
                return MoneyValue.empty();
            }
            return insertAmount;
        }

        @Override
        @Nonnull
        public MoneyValue extractMoney(@Nonnull MoneyValue extractAmount, boolean simulation) {
            for (IMoneyHandler h : this.handlers) {
                extractAmount = h.extractMoney(extractAmount, simulation);
                if (!extractAmount.isEmpty()) continue;
                return MoneyValue.empty();
            }
            return extractAmount;
        }

        @Override
        public boolean isMoneyTypeValid(@Nonnull MoneyValue value) {
            return this.handlers.stream().anyMatch(h -> h.isMoneyTypeValid(value));
        }

        @Override
        protected boolean hasStoredMoneyChanged() {
            return this.handlers.stream().anyMatch(h -> h.hasStoredMoneyChanged(this));
        }

        @Override
        protected void collectStoredMoney(@Nonnull MoneyView.Builder builder) {
            for (IMoneyHandler h : this.handlers) {
                builder.merge(h.getStoredMoney());
                h.flagAsKnown(this);
            }
        }
    }

    public static abstract class Slave
    implements IMoneyHandler {
        @Nullable
        protected abstract IMoneyHandler getParent();

        @Override
        @Nonnull
        public MoneyValue insertMoney(@Nonnull MoneyValue insertAmount, boolean simulation) {
            IMoneyHandler handler = this.getParent();
            if (handler != null) {
                return handler.insertMoney(insertAmount, simulation);
            }
            return insertAmount;
        }

        @Override
        @Nonnull
        public MoneyValue extractMoney(@Nonnull MoneyValue extractAmount, boolean simulation) {
            IMoneyHandler handler = this.getParent();
            if (handler != null) {
                return handler.extractMoney(extractAmount, simulation);
            }
            return extractAmount;
        }

        @Override
        public boolean isMoneyTypeValid(@Nonnull MoneyValue value) {
            IMoneyHandler handler = this.getParent();
            if (handler != null) {
                return handler.isMoneyTypeValid(value);
            }
            return false;
        }

        @Override
        @Nonnull
        public MoneyView getStoredMoney() {
            IMoneyHandler handler = this.getParent();
            if (handler != null) {
                return handler.getStoredMoney();
            }
            return MoneyView.empty();
        }

        @Override
        public boolean hasStoredMoneyChanged(@Nullable Object context) {
            IMoneyHandler handler = this.getParent();
            if (handler != null) {
                return handler.hasStoredMoneyChanged(context);
            }
            return false;
        }

        @Override
        public void flagAsKnown(@Nullable Object context) {
            IMoneyHandler handler = this.getParent();
            if (handler != null) {
                handler.flagAsKnown(context);
            }
        }

        @Override
        public void forgetContext(@Nonnull Object context) {
            IMoneyHandler handler = this.getParent();
            if (handler != null) {
                handler.forgetContext(context);
            }
        }
    }
}

