/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import io.github.lightman314.lightmanscurrency.CustomCreativeTab;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.groups.BundleRequestFilter;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.common.enchantments.LCEnchantmentCategories;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullSupplier;

public class ModCreativeGroups {
    private static final CustomCreativeTab COIN_GROUP = CustomCreativeTab.build("lightmanscurrency.coins", () -> ModBlocks.COINPILE_GOLD);
    private static final CustomCreativeTab MACHINE_GROUP = CustomCreativeTab.build("lightmanscurrency.machines", () -> ModBlocks.COIN_MINT);
    private static final CustomCreativeTab TRADING_GROUP = CustomCreativeTab.build("lightmanscurrency.trading", () -> ModBlocks.DISPLAY_CASE);
    private static final CustomCreativeTab UPGRADE_GROUP = CustomCreativeTab.build("lightmanscurrency.upgrades", () -> ModItems.ITEM_CAPACITY_UPGRADE_1);
    private static CustomCreativeTab EXTRA_GROUP = null;

    @Nonnull
    public static CustomCreativeTab getCoinGroup() {
        return COIN_GROUP;
    }

    @Nonnull
    public static CustomCreativeTab getMachineGroup() {
        return MACHINE_GROUP;
    }

    @Nonnull
    public static CustomCreativeTab getTradingGroup() {
        return TRADING_GROUP;
    }

    @Nonnull
    public static CustomCreativeTab getUpgradeGroup() {
        return UPGRADE_GROUP;
    }

    @Nonnull
    public static CustomCreativeTab getExtraGroup() {
        if (EXTRA_GROUP == null) {
            EXTRA_GROUP = CustomCreativeTab.build2("lightmanscurrency.extra", ModCreativeGroups.ezRandomIcon(ModCreativeGroups::getExtraGroup));
        }
        return EXTRA_GROUP;
    }

    public static NonNullFunction<WoodType, CreativeModeTab> getExtraOr(NonNullSupplier<CreativeModeTab> normalSource) {
        return w -> w.isModded() ? ModCreativeGroups.getExtraGroup() : (CreativeModeTab)normalSource.get();
    }

    public static void setupCreativeTabs() {
        COIN_GROUP.m_40781_(new EnchantmentCategory[]{LCEnchantmentCategories.WALLET_CATEGORY, LCEnchantmentCategories.WALLET_PICKUP_CATEGORY});
        COIN_GROUP.startInit().add(ModItems.COIN_COPPER, ModBlocks.COINPILE_COPPER, ModBlocks.COINBLOCK_COPPER, ModItems.COIN_IRON, ModBlocks.COINPILE_IRON, ModBlocks.COINBLOCK_IRON, ModItems.COIN_GOLD, ModBlocks.COINPILE_GOLD, ModBlocks.COINBLOCK_GOLD, ModItems.COIN_EMERALD, ModBlocks.COINPILE_EMERALD, ModBlocks.COINBLOCK_EMERALD, ModItems.COIN_DIAMOND, ModBlocks.COINPILE_DIAMOND, ModBlocks.COINBLOCK_DIAMOND, ModItems.COIN_NETHERITE, ModBlocks.COINPILE_NETHERITE, ModBlocks.COINBLOCK_NETHERITE, ModItems.WALLET_COPPER, ModItems.WALLET_IRON, ModItems.WALLET_GOLD, ModItems.WALLET_EMERALD, ModItems.WALLET_DIAMOND, ModItems.WALLET_NETHERITE, ModItems.TRADING_CORE, ModItems.COIN_CHOCOLATE_COPPER, ModBlocks.COINPILE_CHOCOLATE_COPPER, ModBlocks.COINBLOCK_CHOCOLATE_COPPER, ModItems.COIN_CHOCOLATE_IRON, ModBlocks.COINPILE_CHOCOLATE_IRON, ModBlocks.COINBLOCK_CHOCOLATE_IRON, ModItems.COIN_CHOCOLATE_GOLD, ModBlocks.COINPILE_CHOCOLATE_GOLD, ModBlocks.COINBLOCK_CHOCOLATE_GOLD, ModItems.COIN_CHOCOLATE_EMERALD, ModBlocks.COINPILE_CHOCOLATE_EMERALD, ModBlocks.COINBLOCK_CHOCOLATE_EMERALD, ModItems.COIN_CHOCOLATE_DIAMOND, ModBlocks.COINPILE_CHOCOLATE_DIAMOND, ModBlocks.COINBLOCK_CHOCOLATE_DIAMOND, ModItems.COIN_CHOCOLATE_NETHERITE, ModBlocks.COINPILE_CHOCOLATE_NETHERITE, ModBlocks.COINBLOCK_CHOCOLATE_NETHERITE).build();
        MACHINE_GROUP.startInit().add(ModBlocks.COIN_MINT, ModBlocks.ATM, ModItems.PORTABLE_ATM, ModBlocks.CASH_REGISTER, ModBlocks.TERMINAL, ModItems.PORTABLE_TERMINAL, ModBlocks.GEM_TERMINAL, ModItems.PORTABLE_GEM_TERMINAL, ModBlocks.ITEM_TRADER_INTERFACE, ModBlocks.TAX_COLLECTOR, ModBlocks.AUCTION_STAND.getAllSorted(BundleRequestFilter.VANILLA), ModBlocks.TICKET_STATION, ModItems.TICKET_MASTER, ModItems.TICKET_PASS, ModItems.TICKET, ModItems.TICKET_STUB, ModItems.GOLDEN_TICKET_MASTER, ModItems.GOLDEN_TICKET_PASS, ModItems.GOLDEN_TICKET, ModItems.GOLDEN_TICKET_STUB, ModBlocks.COIN_CHEST, ModBlocks.PIGGY_BANK, ModBlocks.COINJAR_BLUE, ModBlocks.SUS_JAR).build();
        TRADING_GROUP.startInit().add(ModBlocks.SHELF.getAllSorted(BundleRequestFilter.VANILLA), ModBlocks.SHELF_2x2.getAllSorted(BundleRequestFilter.VANILLA), ModBlocks.DISPLAY_CASE, ModBlocks.CARD_DISPLAY.getAllSorted(BundleRequestFilter.VANILLA), ModBlocks.VENDING_MACHINE, ModBlocks.FREEZER, ModBlocks.VENDING_MACHINE_LARGE, ModBlocks.ARMOR_DISPLAY, ModBlocks.TICKET_KIOSK, ModBlocks.BOOKSHELF_TRADER, ModBlocks.SLOT_MACHINE, ModBlocks.ITEM_NETWORK_TRADER_1, ModBlocks.ITEM_NETWORK_TRADER_2, ModBlocks.ITEM_NETWORK_TRADER_3, ModBlocks.ITEM_NETWORK_TRADER_4, ModBlocks.PAYGATE).build();
        UPGRADE_GROUP.startInit().add(ModItems.ITEM_CAPACITY_UPGRADE_1, ModItems.ITEM_CAPACITY_UPGRADE_2, ModItems.ITEM_CAPACITY_UPGRADE_3, ModItems.SPEED_UPGRADE_1, ModItems.SPEED_UPGRADE_2, ModItems.SPEED_UPGRADE_3, ModItems.SPEED_UPGRADE_4, ModItems.SPEED_UPGRADE_5, ModItems.NETWORK_UPGRADE, ModItems.HOPPER_UPGRADE, ModItems.COIN_CHEST_EXCHANGE_UPGRADE, ModItems.COIN_CHEST_MAGNET_UPGRADE_1, ModItems.COIN_CHEST_MAGNET_UPGRADE_2, ModItems.COIN_CHEST_MAGNET_UPGRADE_3, ModItems.COIN_CHEST_MAGNET_UPGRADE_4, ModItems.COIN_CHEST_SECURITY_UPGRADE).build();
        if (EXTRA_GROUP != null) {
            EXTRA_GROUP.startInit().add(ModBlocks.AUCTION_STAND.getAllSorted(BundleRequestFilter.MODDED), ModBlocks.SHELF.getAllSorted(BundleRequestFilter.MODDED), ModBlocks.CARD_DISPLAY.getAllSorted(BundleRequestFilter.MODDED), ModBlocks.BOOKSHELF_TRADER.getAllSorted(BundleRequestFilter.MODDED)).build();
        }
    }

    private static Supplier<ItemStack> ezRandomIcon(Supplier<CreativeModeTab> tabSource) {
        return () -> {
            CreativeModeTab tab = (CreativeModeTab)tabSource.get();
            NonNullList list = NonNullList.m_122779_();
            tab.m_6151_(list);
            if (list.isEmpty()) {
                return new ItemStack((ItemLike)ModItems.TRADING_CORE.get());
            }
            return (ItemStack)list.get((int)(TimeUtil.getCurrentTime() / 1000L % (long)list.size()));
        };
    }
}

