/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBiBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;

public class CustomCreativeTab
extends CreativeModeTab {
    private final ItemSorter itemSorter;
    Supplier<ItemStack> iconItem;

    private CustomCreativeTab(String label, Supplier<ItemStack> iconItem) {
        super(label);
        this.iconItem = iconItem;
        this.itemSorter = new ItemSorter(label);
    }

    public static CustomCreativeTab build(String label, Supplier<RegistryObject<? extends ItemLike>> iconItem) {
        return new CustomCreativeTab(label, () -> new ItemStack((ItemLike)((RegistryObject)iconItem.get()).get()));
    }

    public static CustomCreativeTab build2(String label, Supplier<ItemStack> iconItem) {
        return new CustomCreativeTab(label, () -> (ItemStack)iconItem.get());
    }

    public ItemStack m_6976_() {
        if (this.iconItem != null) {
            return this.iconItem.get();
        }
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6151_(NonNullList<ItemStack> items) {
        super.m_6151_(items);
        items.sort((Comparator)this.itemSorter);
    }

    public final ItemSorterBuilder startInit() {
        return new ItemSorterBuilder(this.itemSorter);
    }

    public void addToSortingList(List<ItemLike> extras) {
        this.itemSorter.addToSortingList(extras);
    }

    @Deprecated
    public void initSortingList(List<ItemLike> defaultList) {
        this.itemSorter.initSortingList(defaultList);
    }

    @Deprecated
    public void initSortingList2(List<RegistryObject<? extends ItemLike>> defaultList) {
        ArrayList<ItemLike> list = new ArrayList<ItemLike>();
        for (RegistryObject<? extends ItemLike> item : defaultList) {
            ItemLike i = (ItemLike)item.get();
            if (i == null) continue;
            list.add(i);
        }
        this.itemSorter.initSortingList(list);
    }

    private static class ItemSorter
    implements Comparator<ItemStack> {
        private final String groupName;
        private ArrayList<Item> sortList = null;

        public ItemSorter(@Nonnull String groupName) {
            this.groupName = groupName;
        }

        private ArrayList<Item> convertList(List<ItemLike> sourceList) {
            ArrayList list = Lists.newArrayList();
            for (ItemLike itemLike : sourceList) {
                list.add(itemLike.m_5456_());
            }
            return list;
        }

        @Deprecated
        public void initSortingList(List<ItemLike> sortList) {
            if (this.sortList == null) {
                this.sortList = this.convertList(sortList);
            } else {
                ArrayList<Item> copyList = this.sortList;
                this.sortList = this.convertList(sortList);
                this.sortList.addAll(copyList);
            }
        }

        public void initSortingList(ItemSorterBuilder builder) {
            if (this.sortList == null) {
                this.sortList = new ArrayList<Item>(builder.sortList);
            } else {
                ArrayList<Item> copyList = this.sortList;
                this.sortList = new ArrayList<Item>(builder.sortList);
                this.sortList.addAll(copyList);
            }
        }

        public void addToSortingList(List<ItemLike> extras) {
            if (this.sortList == null) {
                this.sortList = this.convertList(extras);
                return;
            }
            for (ItemLike extra : extras) {
                this.sortList.add(extra.m_5456_());
            }
            LightmansCurrency.LogInfo("Added " + extras.size() + " items to the creative tab sorting list.");
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            Item item1 = o1.m_41720_();
            Item item2 = o2.m_41720_();
            if (this.sortList == null) {
                LightmansCurrency.LogWarning("No sortlist defined for the " + EasyText.translatable(this.groupName, new Object[0]).getString() + " Creative Group.");
                return 0;
            }
            if (this.sortList.contains(item1) && !this.sortList.contains(item2)) {
                return -1;
            }
            if (!this.sortList.contains(item1) && this.sortList.contains(item2)) {
                return 1;
            }
            if (this.sortListContains(item1) && this.sortListContains(item2)) {
                return Integer.compare(this.indexOf(item1), this.indexOf(item2));
            }
            return 0;
        }

        private boolean sortListContains(Item item) {
            return this.indexOf(item) >= 0;
        }

        private int indexOf(Item item) {
            return this.sortList.indexOf(item);
        }
    }

    public static final class ItemSorterBuilder {
        private final ItemSorter sorter;
        private final ArrayList<Item> sortList = new ArrayList();

        private ItemSorterBuilder(ItemSorter sorter) {
            this.sorter = sorter;
        }

        public ItemSorterBuilder add(Object ... items) {
            for (Object object : items) {
                this.addItem(object);
            }
            return this;
        }

        private void addItem(Object object) {
            if (object instanceof ItemLike) {
                ItemLike item = (ItemLike)object;
                this.addItem(item.m_5456_());
            } else if (object instanceof RegistryObject) {
                RegistryObject registryObject = (RegistryObject)object;
                this.addItem(registryObject.get());
            } else if (object instanceof RegistryObjectBundle) {
                RegistryObjectBundle bundle = (RegistryObjectBundle)object;
                for (Object obj : bundle.getAllSorted()) {
                    this.addItem(obj);
                }
            } else if (object instanceof RegistryObjectBiBundle) {
                RegistryObjectBiBundle bundle = (RegistryObjectBiBundle)object;
                for (Object obj : bundle.getAllSorted()) {
                    this.addItem(obj);
                }
            } else if (object instanceof List) {
                List list = (List)object;
                for (Object obj : list) {
                    this.addItem(obj);
                }
            } else {
                LightmansCurrency.LogWarning("Could not parse '" + object.getClass().getName() + "' as an item for the sorting list.");
            }
        }

        private void addItem(Item item) {
            if (!this.sortList.contains(item)) {
                this.sortList.add(item);
            }
        }

        public void build() {
            this.sorter.initSortingList(this);
        }
    }
}

