/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.systems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.BlockSnapshot;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.ServerConfig;
import nl.requios.effortlessbuilding.utilities.BlockSet;
import nl.requios.effortlessbuilding.utilities.FixedStack;
import nl.requios.effortlessbuilding.utilities.InventoryHelper;

public class UndoRedo {
    public final Map<UUID, FixedStack<BlockSet>> undoStacks = new HashMap<UUID, FixedStack<BlockSet>>();
    public final Map<UUID, FixedStack<BlockSet>> redoStacks = new HashMap<UUID, FixedStack<BlockSet>>();

    public boolean isAllowedToUndo(Player player) {
        return true;
    }

    public void addUndo(Player player, BlockSet blockSet) {
        if (blockSet.isEmpty() || !this.isAllowedToUndo(player)) {
            return;
        }
        if (!this.undoStacks.containsKey(player.m_20148_())) {
            this.undoStacks.put(player.m_20148_(), new FixedStack<BlockSet>(new BlockSet[((Integer)ServerConfig.memory.undoStackSize.get()).intValue()]));
        }
        this.undoStacks.get(player.m_20148_()).push(blockSet);
    }

    public void addRedo(Player player, BlockSet blockSet) {
        if (blockSet.isEmpty() || !this.isAllowedToUndo(player)) {
            return;
        }
        if (!this.redoStacks.containsKey(player.m_20148_())) {
            this.redoStacks.put(player.m_20148_(), new FixedStack<BlockSet>(new BlockSet[((Integer)ServerConfig.memory.undoStackSize.get()).intValue()]));
        }
        this.redoStacks.get(player.m_20148_()).push(blockSet);
    }

    public boolean undo(Player player) {
        if (!this.isAllowedToUndo(player)) {
            EffortlessBuilding.log(player, ChatFormatting.RED + "You are not allowed to undo.");
            return false;
        }
        if (!this.undoStacks.containsKey(player.m_20148_())) {
            return false;
        }
        FixedStack<BlockSet> undoStack = this.undoStacks.get(player.m_20148_());
        if (undoStack.isEmpty()) {
            return false;
        }
        BlockSet blockSet = undoStack.pop();
        EffortlessBuilding.SERVER_BLOCK_PLACER.undoBlockSet(player, blockSet);
        return true;
    }

    public boolean redo(Player player) {
        if (!this.isAllowedToUndo(player)) {
            EffortlessBuilding.log(player, ChatFormatting.RED + "You are not allowed to undo.");
            return false;
        }
        if (!this.redoStacks.containsKey(player.m_20148_())) {
            return false;
        }
        FixedStack<BlockSet> redoStack = this.redoStacks.get(player.m_20148_());
        if (redoStack.isEmpty()) {
            return false;
        }
        BlockSet blockSet = redoStack.pop();
        EffortlessBuilding.SERVER_BLOCK_PLACER.applyBlockSet(player, blockSet);
        return true;
    }

    public void clear(Player player) {
        if (this.undoStacks.containsKey(player.m_20148_())) {
            this.undoStacks.get(player.m_20148_()).clear();
        }
        if (this.redoStacks.containsKey(player.m_20148_())) {
            this.redoStacks.get(player.m_20148_()).clear();
        }
    }

    private List<ItemStack> findItemStacksInInventory(Player player, List<BlockState> blockStates) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(blockStates.size());
        for (BlockState blockState : blockStates) {
            itemStacks.add(this.findItemStackInInventory(player, blockState));
        }
        return itemStacks;
    }

    private ItemStack findItemStackInInventory(Player player, BlockState blockState) {
        ItemStack itemStack = ItemStack.f_41583_;
        if (blockState == null) {
            return itemStack;
        }
        itemStack = InventoryHelper.findItemStackInInventory(player, blockState.m_60734_());
        if (itemStack.m_41619_() && !player.f_19853_.f_46443_) {
            List itemsDropped = Block.m_49869_((BlockState)blockState, (ServerLevel)((ServerLevel)player.f_19853_), (BlockPos)BlockPos.f_121853_, null);
            for (ItemStack itemStackDropped : itemsDropped) {
                if (!(itemStackDropped.m_41720_() instanceof BlockItem)) continue;
                Block block = ((BlockItem)itemStackDropped.m_41720_()).m_40614_();
                itemStack = InventoryHelper.findItemStackInInventory(player, block);
            }
        }
        return itemStack;
    }

    public class UndoSet {
        public final List<BlockSnapshot> blockSnapshots;

        public UndoSet(List<BlockSnapshot> blockSnapshots) {
            this.blockSnapshots = blockSnapshots;
        }
    }
}

