/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.systems;

import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.ClientConfig;
import nl.requios.effortlessbuilding.ClientEvents;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmode.BuildModeEnum;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.item.AbstractRandomizerBagItem;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.network.ServerBreakBlocksPacket;
import nl.requios.effortlessbuilding.network.ServerPlaceBlocksPacket;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import nl.requios.effortlessbuilding.utilities.BlockSet;
import nl.requios.effortlessbuilding.utilities.ClientBlockUtilities;
import nl.requios.effortlessbuilding.utilities.SurvivalHelper;

@OnlyIn(value=Dist.CLIENT)
public class BuilderChain {
    private final BlockSet blocks = new BlockSet();
    private Item previousHeldItem;
    private int soundTime = 0;
    private BlockEntry startPosForPlacing;
    private BlockPos startPosForBreaking;
    private BlockHitResult lookingAtNear;
    private BlockHitResult lookingAt;
    private BuildingState buildingState = BuildingState.IDLE;
    private AbilitiesState abilitiesState = AbilitiesState.CAN_PLACE_AND_BREAK;

    public void onRightClick() {
        if (this.abilitiesState != AbilitiesState.CAN_PLACE_AND_BREAK || this.buildingState == BuildingState.BREAKING) {
            this.cancel();
            return;
        }
        if (this.buildingState == BuildingState.IDLE) {
            this.buildingState = BuildingState.PLACING;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BuildModeEnum buildMode = EffortlessBuildingClient.BUILD_MODES.getBuildMode();
        if (buildMode.instance.onClick(this.blocks)) {
            this.buildingState = BuildingState.IDLE;
            if (!this.blocks.isEmpty()) {
                EffortlessBuildingClient.BLOCK_PREVIEWS.onBlocksPlaced(this.blocks);
                ClientBlockUtilities.playSoundIfFurtherThanNormal((Player)player, this.blocks.getLastBlockEntry(), false);
                player.m_6674_(InteractionHand.MAIN_HAND);
                this.blocks.skipFirst = buildMode == BuildModeEnum.DISABLED;
                long placeTime = player.f_19853_.m_46467_();
                if (this.blocks.size() > 1) {
                    placeTime += (long)((Integer)ClientConfig.visuals.appearAnimationLength.get()).intValue();
                }
                PacketHandler.INSTANCE.sendToServer((Object)new ServerPlaceBlocksPacket(this.blocks, placeTime));
            }
        }
    }

    public void onLeftClick() {
        if (this.abilitiesState == AbilitiesState.NONE || this.buildingState == BuildingState.PLACING) {
            this.cancel();
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !EffortlessBuildingClient.POWER_LEVEL.canBreakFar((Player)player)) {
            return;
        }
        if (this.buildingState == BuildingState.IDLE) {
            this.buildingState = BuildingState.BREAKING;
            this.blocks.setStartPos(new BlockEntry(this.startPosForBreaking));
            EffortlessBuildingClient.BUILD_MODIFIERS.findCoordinates(this.blocks, (Player)player);
            EffortlessBuildingClient.BUILDER_FILTER.filterOnCoordinates(this.blocks, (Player)player);
            this.findExistingBlockStates(player.f_19853_);
            EffortlessBuildingClient.BUILDER_FILTER.filterOnExistingBlockStates(this.blocks, (Player)player);
        }
        BuildModeEnum buildMode = EffortlessBuildingClient.BUILD_MODES.getBuildMode();
        if (buildMode.instance.onClick(this.blocks)) {
            this.buildingState = BuildingState.IDLE;
            if (!this.blocks.isEmpty()) {
                EffortlessBuildingClient.BLOCK_PREVIEWS.onBlocksBroken(this.blocks);
                ClientBlockUtilities.playSoundIfFurtherThanNormal((Player)player, this.blocks.getLastBlockEntry(), true);
                player.m_6674_(InteractionHand.MAIN_HAND);
                this.blocks.skipFirst = buildMode == BuildModeEnum.DISABLED;
                PacketHandler.INSTANCE.sendToServer((Object)new ServerBreakBlocksPacket(this.blocks));
            }
        }
    }

    public void onTick() {
        HashSet<BlockPos> previousCoordinates = new HashSet<BlockPos>(this.blocks.getCoordinates());
        this.blocks.clear();
        this.startPosForPlacing = null;
        this.startPosForBreaking = null;
        this.lookingAtNear = null;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel world = mc.f_91073_;
        this.abilitiesState = this.determineAbilities(mc, (Player)player, (Level)world);
        if (this.abilitiesState == AbilitiesState.NONE) {
            return;
        }
        BuildModeEnum buildMode = EffortlessBuildingClient.BUILD_MODES.getBuildMode();
        if (this.buildingState == BuildingState.IDLE) {
            BlockEntry startEntry = this.findStartPosition((Player)player, buildMode);
            if (startEntry != null) {
                this.blocks.setStartPos(startEntry);
            } else {
                this.abilitiesState = AbilitiesState.NONE;
                return;
            }
        }
        EffortlessBuildingClient.BUILD_MODES.findCoordinates(this.blocks, (Player)player);
        EffortlessBuildingClient.BUILD_MODIFIERS.findCoordinates(this.blocks, (Player)player);
        EffortlessBuildingClient.BUILDER_FILTER.filterOnCoordinates(this.blocks, (Player)player);
        if (buildMode == BuildModeEnum.DISABLED && this.blocks.size() <= 1) {
            this.abilitiesState = AbilitiesState.NONE;
            return;
        }
        this.findExistingBlockStates((Level)world);
        EffortlessBuildingClient.BUILDER_FILTER.filterOnExistingBlockStates(this.blocks, (Player)player);
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        this.findNewBlockStates((Player)player, heldItem);
        if (this.previousHeldItem != heldItem.m_41720_() || !previousCoordinates.equals(this.blocks.getCoordinates())) {
            this.onBlocksChanged((Player)player);
        }
        this.previousHeldItem = heldItem.m_41720_();
    }

    private AbilitiesState determineAbilities(Minecraft mc, Player player, Level world) {
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult != null && hitResult.m_6662_() == HitResult.Type.BLOCK) {
            this.lookingAtNear = (BlockHitResult)hitResult;
        }
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        boolean blockInHand = CompatHelper.isItemBlockProxy(itemStack);
        boolean lookingAtInteractiveObject = ClientBlockUtilities.determineIfLookingAtInteractiveObject(mc, world);
        boolean isShiftKeyDown = player.m_6144_();
        if (lookingAtInteractiveObject && !isShiftKeyDown) {
            return AbilitiesState.NONE;
        }
        if (!blockInHand) {
            return AbilitiesState.CAN_BREAK;
        }
        return AbilitiesState.CAN_PLACE_AND_BREAK;
    }

    private BlockEntry findStartPosition(Player player, BuildModeEnum buildMode) {
        BlockEntry blockEntry;
        int maxReach = EffortlessBuildingClient.POWER_LEVEL.getPlacementReach(player);
        boolean shouldLookAtNear = buildMode == BuildModeEnum.DISABLED || maxReach < 3;
        this.lookingAt = shouldLookAtNear ? this.lookingAtNear : ClientBlockUtilities.getLookingAtFar(player);
        if (this.lookingAt == null || this.lookingAt.m_6662_() == HitResult.Type.MISS) {
            return null;
        }
        BlockPos startPos = this.lookingAt.m_82425_();
        if (!shouldLookAtNear && player.m_20183_().m_123331_((Vec3i)startPos) > (double)(maxReach * maxReach)) {
            return null;
        }
        this.startPosForBreaking = startPos;
        if (this.abilitiesState == AbilitiesState.CAN_PLACE_AND_BREAK) {
            boolean shouldOffsetStartPosition = EffortlessBuildingClient.BUILD_SETTINGS.shouldOffsetStartPosition();
            boolean replaceable = player.f_19853_.m_8055_(startPos).m_60767_().m_76336_();
            boolean becomesDoubleSlab = SurvivalHelper.doesBecomeDoubleSlab(player, startPos);
            if (!(shouldOffsetStartPosition || replaceable || becomesDoubleSlab)) {
                startPos = startPos.m_121945_(this.lookingAt.m_82434_());
            }
        } else if (!shouldLookAtNear && !EffortlessBuildingClient.POWER_LEVEL.canBreakFar(player)) {
            return null;
        }
        this.startPosForPlacing = blockEntry = new BlockEntry(startPos);
        return blockEntry;
    }

    private void findExistingBlockStates(Level world) {
        for (BlockEntry blockEntry : this.blocks) {
            blockEntry.existingBlockState = world.m_8055_(blockEntry.blockPos);
        }
    }

    private void findNewBlockStates(Player player, ItemStack heldItem) {
        if (this.buildingState == BuildingState.BREAKING) {
            return;
        }
        Direction originalDirection = player.m_6350_();
        Direction clickedFace = this.lookingAt.m_82434_();
        Vec3 relativeHitVec = this.lookingAt.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)this.lookingAt.m_82425_()));
        EffortlessBuildingClient.ITEM_USAGE_TRACKER.initialize();
        if (CompatHelper.isItemBlockProxy(heldItem, false)) {
            AbstractRandomizerBagItem.resetRandomness();
        }
        Iterator iter = this.blocks.entrySet().iterator();
        while (iter.hasNext()) {
            BlockEntry blockEntry = (BlockEntry)iter.next().getValue();
            ItemStack itemStack = this.determineItemStack(player, heldItem);
            if (itemStack == null || itemStack.m_41619_()) {
                iter.remove();
                continue;
            }
            blockEntry.setItemAndFindNewBlockState(itemStack, player.f_19853_, originalDirection, clickedFace, relativeHitVec);
            if (EffortlessBuildingClient.BUILDER_FILTER.filterOnNewBlockState(blockEntry, player)) {
                iter.remove();
                continue;
            }
            blockEntry.invalid = !EffortlessBuildingClient.ITEM_USAGE_TRACKER.increaseUsageCount(itemStack.m_41720_(), 1, player);
        }
        EffortlessBuildingClient.ITEM_USAGE_TRACKER.calculateMissingItems(player);
    }

    private ItemStack determineItemStack(Player player, ItemStack heldItem) {
        if (heldItem.m_41720_() instanceof BlockItem) {
            return heldItem;
        }
        if (CompatHelper.isItemBlockProxy(heldItem, false)) {
            return CompatHelper.getItemBlockFromStack(heldItem);
        }
        return null;
    }

    private void onBlocksChanged(Player player) {
        AbstractRandomizerBagItem.renewRandomness();
        if (this.blocks.size() > 1 && this.soundTime < ClientEvents.ticksInGame) {
            this.soundTime = ClientEvents.ticksInGame;
            if (this.blocks.getLastBlockEntry() != null && this.blocks.getLastBlockEntry().newBlockState != null) {
                BlockState lastBlockState = this.blocks.getLastBlockEntry().newBlockState;
                SoundType soundType = lastBlockState.m_60734_().getSoundType(lastBlockState, (LevelReader)player.f_19853_, this.blocks.lastPos, (Entity)player);
                SoundEvent soundEvent = this.buildingState == BuildingState.BREAKING ? soundType.m_56775_() : soundType.m_56777_();
                player.f_19853_.m_5594_(player, player.m_20183_(), soundEvent, SoundSource.BLOCKS, 0.3f, 0.8f);
            }
        }
    }

    public void cancel() {
        if (this.buildingState == BuildingState.IDLE) {
            return;
        }
        this.buildingState = BuildingState.IDLE;
        EffortlessBuildingClient.BUILD_MODES.onCancel();
        Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12498_, 4.0f, 1.0f);
    }

    public BlockSet getBlocks() {
        return this.blocks;
    }

    public BuildingState getBuildingState() {
        return this.buildingState;
    }

    public AbilitiesState getAbilitiesState() {
        return this.abilitiesState;
    }

    public BuildingState getPretendBuildingState() {
        if (this.buildingState != BuildingState.IDLE) {
            return this.buildingState;
        }
        if (this.abilitiesState == AbilitiesState.CAN_PLACE_AND_BREAK) {
            return BuildingState.PLACING;
        }
        if (this.abilitiesState == AbilitiesState.CAN_BREAK) {
            return BuildingState.BREAKING;
        }
        return BuildingState.IDLE;
    }

    public BlockEntry getStartPosForPlacing() {
        return this.startPosForPlacing;
    }

    public BlockPos getStartPosForBreaking() {
        return this.startPosForBreaking;
    }

    public BlockEntry getStartPos() {
        if (this.getPretendBuildingState() == BuildingState.BREAKING) {
            return new BlockEntry(this.getStartPosForBreaking());
        }
        return this.getStartPosForPlacing();
    }

    public BlockHitResult getLookingAtNear() {
        return this.lookingAtNear;
    }

    public static enum BuildingState {
        IDLE,
        PLACING,
        BREAKING;

    }

    public static enum AbilitiesState {
        CAN_PLACE_AND_BREAK,
        CAN_BREAK,
        NONE;

    }
}

