/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmode;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import nl.requios.effortlessbuilding.ClientEvents;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmode.BuildModeEnum;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.create.foundation.item.ItemDescription;
import nl.requios.effortlessbuilding.create.foundation.item.TooltipHelper;
import nl.requios.effortlessbuilding.create.foundation.utility.Components;
import nl.requios.effortlessbuilding.create.foundation.utility.Lang;

public class RadialMenu
extends Screen {
    public static final RadialMenu instance = new RadialMenu();
    private final Vector4f radialButtonColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.5f);
    private final Vector4f sideButtonColor = new Vector4f(0.5f, 0.5f, 0.5f, 0.5f);
    private final Vector4f highlightColor = new Vector4f(0.6f, 0.8f, 1.0f, 0.6f);
    private final Vector4f selectedColor = new Vector4f(0.0f, 0.5f, 1.0f, 0.5f);
    private final Vector4f highlightSelectedColor = new Vector4f(0.2f, 0.7f, 1.0f, 0.7f);
    private final int whiteTextColor = -1;
    private final int watermarkTextColor = -2004318072;
    private final int descriptionTextColor = -578254712;
    private final int optionTextColor = -286331137;
    private final double ringInnerEdge = 30.0;
    private final double ringOuterEdge = 65.0;
    private final double categoryLineWidth = 1.0;
    private final double textDistance = 75.0;
    private final double buttonDistance = 105.0;
    private final float fadeSpeed = 0.3f;
    private final int buildModeDescriptionHeight = 100;
    private final int actionDescriptionWidth = 200;
    public BuildModeEnum switchTo = null;
    public ModeOptions.ActionEnum doAction = null;
    public boolean performedActionUsingMouse;
    private float visibility;

    public RadialMenu() {
        super((Component)Component.m_237115_((String)"effortlessbuilding.screen.radial_menu"));
    }

    public boolean isVisible() {
        return Minecraft.m_91087_().f_91080_ instanceof RadialMenu;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.performedActionUsingMouse = false;
        this.visibility = 0.0f;
    }

    public void m_86600_() {
        super.m_86600_();
        if (!ClientEvents.isKeybindDown(0)) {
            this.m_7379_();
        }
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        boolean canReplace;
        BuildModeEnum currentBuildMode = EffortlessBuildingClient.BUILD_MODES.getBuildMode();
        ms.m_85836_();
        ms.m_85837_(0.0, 0.0, 200.0);
        this.visibility += 0.3f * partialTicks;
        if (this.visibility > 1.0f) {
            this.visibility = 1.0f;
        }
        int startColor = (int)(this.visibility * 98.0f) << 24;
        int endColor = (int)(this.visibility * 128.0f) << 24;
        this.m_93179_(ms, 0, 0, this.f_96543_, this.f_96544_, startColor, endColor);
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        double middleX = (double)this.f_96543_ / 2.0;
        double middleY = (double)this.f_96544_ / 2.0;
        int mouseXX = (int)(this.f_96541_.f_91067_.m_91589_() * (double)this.f_96541_.m_91268_().m_85445_() / (double)this.f_96541_.m_91268_().m_85443_());
        int mouseYY = (int)(this.f_96541_.f_91067_.m_91594_() * (double)this.f_96541_.m_91268_().m_85446_() / (double)this.f_96541_.m_91268_().m_85444_());
        double mouseXCenter = (double)mouseXX - middleX;
        double mouseYCenter = (double)mouseYY - middleY;
        double mouseRadians = Math.atan2(mouseYCenter, mouseXCenter);
        double quarterCircle = 1.5707963267948966;
        if (mouseRadians < -1.5707963267948966) {
            mouseRadians += Math.PI * 2;
        }
        ArrayList<MenuRegion> modes = new ArrayList<MenuRegion>();
        ArrayList<MenuButton> buttons = new ArrayList<MenuButton>();
        for (BuildModeEnum mode : BuildModeEnum.values()) {
            modes.add(new MenuRegion(mode));
        }
        boolean bl = canReplace = this.f_96541_.f_91074_ != null && EffortlessBuildingClient.POWER_LEVEL.canReplaceBlocks((Player)this.f_96541_.f_91074_);
        if (canReplace) {
            buttons.add(new MenuButton(ModeOptions.ActionEnum.TOGGLE_PROTECT_TILE_ENTITIES, -183.0, -13.0, Direction.UP));
        }
        buttons.add(new MenuButton(ModeOptions.ActionEnum.OPEN_MODIFIER_SETTINGS, -157.0, -13.0, Direction.UP));
        buttons.add(new MenuButton(ModeOptions.ActionEnum.UNDO, -131.0, -13.0, Direction.UP));
        buttons.add(new MenuButton(ModeOptions.ActionEnum.REDO, -105.0, -13.0, Direction.UP));
        if (canReplace) {
            buttons.add(new MenuButton(ModeOptions.ActionEnum.REPLACE_ONLY_AIR, -183.0, 13.0, Direction.DOWN));
            buttons.add(new MenuButton(ModeOptions.ActionEnum.REPLACE_BLOCKS_AND_AIR, -157.0, 13.0, Direction.DOWN));
            buttons.add(new MenuButton(ModeOptions.ActionEnum.REPLACE_ONLY_BLOCKS, -131.0, 13.0, Direction.DOWN));
            buttons.add(new MenuButton(ModeOptions.ActionEnum.REPLACE_FILTERED_BY_OFFHAND, -105.0, 13.0, Direction.DOWN));
        }
        ModeOptions.OptionEnum[] options = currentBuildMode.options;
        for (int i = 0; i < options.length; ++i) {
            for (int j = 0; j < options[i].actions.length; ++j) {
                ModeOptions.ActionEnum action = options[i].actions[j];
                buttons.add(new MenuButton(action, 105.0 + (double)(j * 26), -13 + i * 39, Direction.DOWN));
            }
        }
        this.switchTo = null;
        this.doAction = null;
        this.drawRadialButtonBackgrounds(currentBuildMode, buffer, middleX, middleY, mouseXCenter, mouseYCenter, mouseRadians, 1.5707963267948966, modes);
        this.drawSideButtonBackgrounds(buffer, middleX, middleY, mouseXCenter, mouseYCenter, buttons);
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        this.drawIcons(ms, middleX, middleY, modes, buttons);
        this.drawTexts(ms, currentBuildMode, middleX, middleY, modes, buttons, options, mouseXX, mouseYY);
        ms.m_85849_();
    }

    private void drawRadialButtonBackgrounds(BuildModeEnum currentBuildMode, BufferBuilder buffer, double middleX, double middleY, double mouseXCenter, double mouseYCenter, double mouseRadians, double quarterCircle, ArrayList<MenuRegion> modes) {
        if (!modes.isEmpty()) {
            int totalModes = Math.max(3, modes.size());
            double fragment = 0.015707963267948967;
            double fragment2 = 0.007853981633974483;
            double radiansPerObject = Math.PI * 2 / (double)totalModes;
            for (int i = 0; i < modes.size(); ++i) {
                MenuRegion menuRegion = modes.get(i);
                double beginRadians = (double)i * radiansPerObject - quarterCircle;
                double endRadians = (double)(i + 1) * radiansPerObject - quarterCircle;
                menuRegion.x1 = Math.cos(beginRadians);
                menuRegion.x2 = Math.cos(endRadians);
                menuRegion.y1 = Math.sin(beginRadians);
                menuRegion.y2 = Math.sin(endRadians);
                double x1m1 = Math.cos(beginRadians + 0.015707963267948967) * 30.0;
                double x2m1 = Math.cos(endRadians - 0.015707963267948967) * 30.0;
                double y1m1 = Math.sin(beginRadians + 0.015707963267948967) * 30.0;
                double y2m1 = Math.sin(endRadians - 0.015707963267948967) * 30.0;
                double x1m2 = Math.cos(beginRadians + 0.007853981633974483) * 65.0;
                double x2m2 = Math.cos(endRadians - 0.007853981633974483) * 65.0;
                double y1m2 = Math.sin(beginRadians + 0.007853981633974483) * 65.0;
                double y2m2 = Math.sin(endRadians - 0.007853981633974483) * 65.0;
                boolean isSelected = currentBuildMode.ordinal() == i;
                boolean isMouseInQuad = this.inTriangle(x1m1, y1m1, x2m2, y2m2, x2m1, y2m1, mouseXCenter, mouseYCenter) || this.inTriangle(x1m1, y1m1, x1m2, y1m2, x2m2, y2m2, mouseXCenter, mouseYCenter);
                boolean isHighlighted = beginRadians <= mouseRadians && mouseRadians <= endRadians && isMouseInQuad;
                Vector4f color = this.radialButtonColor;
                if (isSelected) {
                    color = this.selectedColor;
                }
                if (isHighlighted) {
                    color = this.highlightColor;
                }
                if (isSelected && isHighlighted) {
                    color = this.highlightSelectedColor;
                }
                if (isHighlighted) {
                    menuRegion.highlighted = true;
                    this.switchTo = menuRegion.mode;
                }
                buffer.m_5483_(middleX + x1m1, middleY + y1m1, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
                buffer.m_5483_(middleX + x2m1, middleY + y2m1, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
                buffer.m_5483_(middleX + x2m2, middleY + y2m2, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
                buffer.m_5483_(middleX + x1m2, middleY + y1m2, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
                color = menuRegion.mode.category.color;
                double categoryLineOuterEdge = 31.0;
                double x1m3 = Math.cos(beginRadians + 0.015707963267948967) * 31.0;
                double x2m3 = Math.cos(endRadians - 0.015707963267948967) * 31.0;
                double y1m3 = Math.sin(beginRadians + 0.015707963267948967) * 31.0;
                double y2m3 = Math.sin(endRadians - 0.015707963267948967) * 31.0;
                buffer.m_5483_(middleX + x1m1, middleY + y1m1, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
                buffer.m_5483_(middleX + x2m1, middleY + y2m1, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
                buffer.m_5483_(middleX + x2m3, middleY + y2m3, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
                buffer.m_5483_(middleX + x1m3, middleY + y1m3, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
            }
        }
    }

    private void drawSideButtonBackgrounds(BufferBuilder buffer, double middleX, double middleY, double mouseXCenter, double mouseYCenter, ArrayList<MenuButton> buttons) {
        for (MenuButton btn : buttons) {
            boolean isHighlighted = btn.x1 <= mouseXCenter && btn.x2 >= mouseXCenter && btn.y1 <= mouseYCenter && btn.y2 >= mouseYCenter;
            boolean isSelected = btn.action == ModeOptions.getBuildSpeed() || btn.action == ModeOptions.getFill() || btn.action == ModeOptions.getCubeFill() || btn.action == ModeOptions.getRaisedEdge() || btn.action == ModeOptions.getLineThickness() || btn.action == ModeOptions.getCircleStart() || btn.action == EffortlessBuildingClient.BUILD_SETTINGS.getReplaceModeActionEnum() || btn.action == ModeOptions.ActionEnum.TOGGLE_PROTECT_TILE_ENTITIES && EffortlessBuildingClient.BUILD_SETTINGS.shouldProtectTileEntities();
            Vector4f color = this.sideButtonColor;
            if (isSelected) {
                color = this.selectedColor;
            }
            if (isHighlighted) {
                color = this.highlightColor;
            }
            if (isSelected && isHighlighted) {
                color = this.highlightSelectedColor;
            }
            if (isHighlighted) {
                btn.highlighted = true;
                this.doAction = btn.action;
            }
            buffer.m_5483_(middleX + btn.x1, middleY + btn.y1, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
            buffer.m_5483_(middleX + btn.x1, middleY + btn.y2, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
            buffer.m_5483_(middleX + btn.x2, middleY + btn.y2, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
            buffer.m_5483_(middleX + btn.x2, middleY + btn.y1, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
        }
    }

    private void drawIcons(PoseStack ms, double middleX, double middleY, ArrayList<MenuRegion> modes, ArrayList<MenuButton> buttons) {
        double y;
        double x;
        ms.m_85836_();
        RenderSystem.m_69493_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (MenuRegion menuRegion : modes) {
            x = (menuRegion.x1 + menuRegion.x2) * 0.5 * 49.25;
            y = (menuRegion.y1 + menuRegion.y2) * 0.5 * 49.25;
            menuRegion.mode.icon.render(ms, (int)(middleX + x - 8.0), (int)(middleY + y - 8.0));
        }
        for (MenuButton button : buttons) {
            x = (button.x1 + button.x2) / 2.0 + 0.01;
            y = (button.y1 + button.y2) / 2.0 + 0.01;
            button.action.icon.render(ms, (int)(middleX + x - 8.0), (int)(middleY + y - 8.0));
        }
        ms.m_85849_();
    }

    private void drawTexts(PoseStack ms, BuildModeEnum currentBuildMode, double middleX, double middleY, ArrayList<MenuRegion> modes, ArrayList<MenuButton> buttons, ModeOptions.OptionEnum[] options, int mouseX, int mouseY) {
        for (int i = 0; i < currentBuildMode.options.length; ++i) {
            ModeOptions.OptionEnum option = options[i];
            this.f_96547_.m_92750_(ms, I18n.m_118938_((String)option.name, (Object[])new Object[0]), (float)((int)(middleX + 105.0 - 9.0)), (float)((int)middleY - 37 + i * 39), -286331137);
        }
        String credits = "Effortless Building";
        this.f_96547_.m_92750_(ms, credits, (float)(this.f_96543_ - this.f_96547_.m_92895_(credits) - 4), (float)(this.f_96544_ - 10), -2004318072);
        String powerLevelValue = this.f_96541_.f_91074_.m_7500_() ? "Creative" : String.valueOf(EffortlessBuildingClient.POWER_LEVEL.getPowerLevel());
        String powerLevelText = I18n.m_118938_((String)"key.effortlessbuilding.power_level", (Object[])new Object[0]) + ": " + powerLevelValue;
        this.f_96547_.m_92750_(ms, powerLevelText, (float)(this.f_96543_ - this.f_96547_.m_92895_(powerLevelText) - 4), (float)(this.f_96544_ - 22), this.f_96541_.f_91074_.m_7500_() ? -2004318072 : ChatFormatting.DARK_PURPLE.m_126665_());
        if (mouseX >= this.f_96543_ - this.f_96547_.m_92895_(powerLevelText) - 14 && mouseX <= this.f_96543_ && mouseY >= this.f_96544_ - 24 && mouseY <= this.f_96544_) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(Components.literal(powerLevelText).m_130940_(ChatFormatting.DARK_PURPLE));
            int placementReach = EffortlessBuildingClient.POWER_LEVEL.getPlacementReach((Player)this.f_96541_.f_91074_);
            tooltip.add(Components.translatable("key.effortlessbuilding.placement_reach").m_130940_(ChatFormatting.GRAY).m_130946_(": " + (String)(placementReach == 0 ? "vanilla" : placementReach + " blocks")));
            tooltip.add(Components.translatable("key.effortlessbuilding.max_blocks_per_axis").m_130940_(ChatFormatting.GRAY).m_130946_(": " + EffortlessBuildingClient.POWER_LEVEL.getMaxBlocksPerAxis((Player)this.f_96541_.f_91074_)));
            tooltip.add(Components.translatable("key.effortlessbuilding.max_blocks_placed_at_once").m_130940_(ChatFormatting.GRAY).m_130946_(": " + EffortlessBuildingClient.POWER_LEVEL.getMaxBlocksPlacedAtOnce((Player)this.f_96541_.f_91074_)));
            tooltip.add(Components.translatable("key.effortlessbuilding.max_mirror_radius").m_130940_(ChatFormatting.GRAY).m_130946_(": " + EffortlessBuildingClient.POWER_LEVEL.getMaxMirrorRadius((Player)this.f_96541_.f_91074_) + " blocks"));
            if (EffortlessBuildingClient.POWER_LEVEL.canIncreasePowerLevel() && !this.f_96541_.f_91074_.m_7500_()) {
                tooltip.add(Components.literal(""));
                tooltip.add(Components.translatable("key.effortlessbuilding.next_power_level").m_130940_(ChatFormatting.DARK_AQUA).m_130946_(": " + EffortlessBuildingClient.POWER_LEVEL.getNextPowerLevel()));
                tooltip.add(Components.translatable("key.effortlessbuilding.placement_reach").m_130940_(ChatFormatting.GRAY).m_130946_(": " + EffortlessBuildingClient.POWER_LEVEL.getPlacementReach((Player)this.f_96541_.f_91074_, true) + " blocks"));
                tooltip.add(Components.translatable("key.effortlessbuilding.max_blocks_per_axis").m_130940_(ChatFormatting.GRAY).m_130946_(": " + EffortlessBuildingClient.POWER_LEVEL.getMaxBlocksPerAxis((Player)this.f_96541_.f_91074_, true)));
                tooltip.add(Components.translatable("key.effortlessbuilding.max_blocks_placed_at_once").m_130940_(ChatFormatting.GRAY).m_130946_(": " + EffortlessBuildingClient.POWER_LEVEL.getMaxBlocksPlacedAtOnce((Player)this.f_96541_.f_91074_, true)));
                tooltip.add(Components.translatable("key.effortlessbuilding.max_mirror_radius").m_130940_(ChatFormatting.GRAY).m_130946_(": " + EffortlessBuildingClient.POWER_LEVEL.getMaxMirrorRadius((Player)this.f_96541_.f_91074_, true) + " blocks"));
                tooltip.add(Components.literal(""));
                tooltip.addAll(TooltipHelper.cutTextComponent((Component)Components.translatable("key.effortlessbuilding.next_power_level_how"), ChatFormatting.GRAY, ChatFormatting.WHITE));
            }
            this.m_96597_(ms, tooltip, mouseX, mouseY);
        }
        for (MenuRegion menuRegion : modes) {
            if (!menuRegion.highlighted) continue;
            double x = (menuRegion.x1 + menuRegion.x2) * 0.5;
            double y = (menuRegion.y1 + menuRegion.y2) * 0.5;
            int fixed_x = (int)(x * 75.0);
            int n = (int)(y * 75.0);
            Objects.requireNonNull(this.f_96547_);
            int fixed_y = n - 9 / 2;
            String text = I18n.m_118938_((String)menuRegion.mode.getNameKey(), (Object[])new Object[0]);
            if (x <= -0.2) {
                fixed_x -= this.f_96547_.m_92895_(text);
            } else if (-0.2 <= x && x <= 0.2) {
                fixed_x -= this.f_96547_.m_92895_(text) / 2;
            }
            this.f_96547_.m_92750_(ms, text, (float)((int)middleX + fixed_x), (float)((int)middleY + fixed_y), -1);
            text = I18n.m_118938_((String)menuRegion.mode.getDescriptionKey(), (Object[])new Object[0]);
            this.f_96547_.m_92750_(ms, text, (float)((int)middleX) - (float)this.f_96547_.m_92895_(text) / 2.0f, (float)((int)middleY + 100), -578254712);
        }
        for (MenuButton button : buttons) {
            MutableComponent keybind;
            if (!button.highlighted) continue;
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(Components.literal(button.name).m_130940_(ChatFormatting.AQUA));
            if (!button.description.isEmpty()) {
                tooltip.add(TooltipHelper.holdShift(ItemDescription.Palette.Blue, RadialMenu.m_96638_()));
                if (RadialMenu.m_96638_()) {
                    tooltip.addAll(TooltipHelper.cutStringTextComponent(button.description, ChatFormatting.GRAY, ChatFormatting.WHITE));
                }
            }
            if ((keybind = this.findKeybind(button)) != null) {
                tooltip.add(Lang.translateDirect("tooltip.keybind", keybind.m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
            }
            this.m_96597_(ms, tooltip, mouseX, mouseY);
        }
    }

    private MutableComponent findKeybind(MenuButton button) {
        int keybindingIndex = -1;
        if (button.action == ModeOptions.ActionEnum.OPEN_MODIFIER_SETTINGS) {
            keybindingIndex = 1;
        }
        if (button.action == ModeOptions.ActionEnum.UNDO) {
            keybindingIndex = 2;
        }
        if (button.action == ModeOptions.ActionEnum.REDO) {
            keybindingIndex = 3;
        }
        if (keybindingIndex != -1) {
            KeyMapping keyMap = ClientEvents.keyBindings[keybindingIndex];
            return Components.keybind(keyMap.m_90860_());
        }
        return null;
    }

    private boolean inTriangle(double x1, double y1, double x2, double y2, double x3, double y3, double x, double y) {
        double ab = (x1 - x) * (y2 - y) - (x2 - x) * (y1 - y);
        double bc = (x2 - x) * (y3 - y) - (x3 - x) * (y2 - y);
        double ca = (x3 - x) * (y1 - y) - (x1 - x) * (y3 - y);
        return this.sign(ab) == this.sign(bc) && this.sign(bc) == this.sign(ca);
    }

    private int sign(double n) {
        return n > 0.0 ? 1 : -1;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.performAction(true);
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_7379_() {
        super.m_7379_();
        if (!this.performedActionUsingMouse) {
            this.performAction(false);
        }
    }

    private void performAction(boolean fromMouseClick) {
        ModeOptions.ActionEnum action;
        if (this.switchTo != null) {
            RadialMenu.playRadialMenuSound();
            EffortlessBuildingClient.BUILD_MODES.setBuildMode(this.switchTo);
            if (fromMouseClick) {
                this.performedActionUsingMouse = true;
            }
        }
        if ((action = this.doAction) != null) {
            RadialMenu.playRadialMenuSound();
            ModeOptions.performAction((Player)this.f_96541_.f_91074_, action);
            if (fromMouseClick) {
                this.performedActionUsingMouse = true;
            }
        }
    }

    public static void playRadialMenuSound() {
        float volume = 0.1f;
        SimpleSoundInstance sound = new SimpleSoundInstance(SoundEvents.f_12490_, SoundSource.MASTER, 0.1f, 1.0f, RandomSource.m_216327_(), Minecraft.m_91087_().f_91074_.m_20183_());
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
    }

    static class MenuRegion {
        public final BuildModeEnum mode;
        public double x1;
        public double x2;
        public double y1;
        public double y2;
        public boolean highlighted;

        public MenuRegion(BuildModeEnum mode) {
            this.mode = mode;
        }
    }

    private static class MenuButton {
        public final ModeOptions.ActionEnum action;
        public double x1;
        public double x2;
        public double y1;
        public double y2;
        public boolean highlighted;
        public String name;
        public String description = "";
        public Direction textSide;

        public MenuButton(ModeOptions.ActionEnum action, double x, double y, Direction textSide) {
            this.name = I18n.m_118938_((String)action.getNameKey(), (Object[])new Object[0]);
            if (I18n.m_118936_((String)action.getDescriptionKey())) {
                this.description = I18n.m_118938_((String)action.getDescriptionKey(), (Object[])new Object[0]);
            }
            this.action = action;
            this.x1 = x - 10.0;
            this.x2 = x + 10.0;
            this.y1 = y - 10.0;
            this.y2 = y + 10.0;
            this.textSide = textSide;
        }
    }
}

