/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmode;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import nl.requios.effortlessbuilding.EffortlessBuilding;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PlayerSettingsGui
extends Screen {
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;
    protected boolean showShaderList = false;
    private Button shaderTypeButton;
    private ShaderTypeList shaderTypeList;
    private Button closeButton;

    public PlayerSettingsGui() {
        super((Component)Component.m_237115_((String)"effortlessbuilding.screen.player_settings"));
    }

    protected void m_7856_() {
        this.left = this.f_96543_ / 2 - 140;
        this.right = this.f_96543_ / 2 + 140;
        this.top = this.f_96544_ / 2 - 100;
        this.bottom = this.f_96544_ / 2 + 100;
        int yy = this.top;
        this.shaderTypeList = new ShaderTypeList(this.f_96541_);
        this.m_7787_((GuiEventListener)this.shaderTypeList);
        Component currentShaderName = ShaderType.DISSOLVE_BLUE.name;
        this.shaderTypeButton = new ExtendedButton(this.right - 180, yy, 180, 20, currentShaderName, button -> {
            this.showShaderList = !this.showShaderList;
        });
        this.m_169394_((Widget)this.shaderTypeButton);
        ForgeSlider slider = new ForgeSlider(this.right - 200, yy += 50, 200, 20, (Component)Component.m_237119_(), (Component)Component.m_237119_(), 0.5, 2.0, 1.0, true);
        this.m_169394_((Widget)slider);
        this.closeButton = new ExtendedButton(this.left + 50, this.bottom - 20, 180, 20, (Component)Component.m_237113_((String)"Done"), button -> this.f_96541_.f_91074_.m_6915_());
        this.m_169394_((Widget)this.closeButton);
    }

    public void m_86600_() {
        super.m_86600_();
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        int yy = this.top;
        this.f_96547_.m_92883_(ms, "Shader type", (float)this.left, (float)(yy + 5), 0xFFFFFF);
        this.f_96547_.m_92883_(ms, "Shader speed", (float)this.left, (float)((yy += 50) + 5), 0xFFFFFF);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        if (this.showShaderList) {
            this.shaderTypeList.m_6305_(ms, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_6375_(mouseX, mouseY, mouseButton);
        if (this.showShaderList && !this.shaderTypeList.m_5953_(mouseX, mouseY) && !this.shaderTypeButton.m_5953_(mouseX, mouseY)) {
            this.showShaderList = false;
        }
        return true;
    }

    public void m_7861_() {
        ShaderTypeList.ShaderTypeEntry selectedShader = (ShaderTypeList.ShaderTypeEntry)this.shaderTypeList.m_93511_();
    }

    @OnlyIn(value=Dist.CLIENT)
    class ShaderTypeList
    extends ObjectSelectionList<ShaderTypeEntry> {
        public ShaderTypeList(Minecraft mcIn) {
            super(mcIn, 180, 140, PlayerSettingsGui.this.top + 20, PlayerSettingsGui.this.top + 100, 18);
            this.m_93507_(PlayerSettingsGui.this.right - this.f_93388_);
            for (int i = 0; i < 40; ++i) {
                for (ShaderType shaderType : ShaderType.values()) {
                    ShaderTypeEntry shaderTypeEntry = new ShaderTypeEntry(shaderType);
                    this.m_7085_((AbstractSelectionList.Entry)shaderTypeEntry);
                }
            }
            if (this.m_93511_() != null) {
                this.m_93494_((AbstractSelectionList.Entry)((ShaderTypeEntry)this.m_93511_()));
            }
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        public void setSelected(ShaderTypeEntry selected) {
            super.m_6987_((AbstractSelectionList.Entry)selected);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            EffortlessBuilding.log("Selected shader " + selected.shaderType.name);
            PlayerSettingsGui.this.shaderTypeButton.m_93666_(selected.shaderType.name);
        }

        public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }

        public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }

        public boolean m_7979_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        }

        public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
        }

        public boolean m_5953_(double p_isMouseOver_1_, double p_isMouseOver_3_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.m_5953_(p_isMouseOver_1_, p_isMouseOver_3_);
        }

        protected boolean m_5694_() {
            return PlayerSettingsGui.this.m_7222_() == this;
        }

        protected int m_5756_() {
            return PlayerSettingsGui.this.right - 6;
        }

        public void m_6305_(PoseStack ms, int p_render_1_, int p_render_2_, float p_render_3_) {
            this.m_7733_(ms);
            int i = this.m_5756_();
            int j = i + 6;
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_6122_(20, 20, 20, 180).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_6122_(20, 20, 20, 180).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_6122_(20, 20, 20, 180).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_6122_(20, 20, 20, 180).m_5752_();
            tessellator.m_85914_();
            int k = this.m_5747_();
            int l = this.f_93390_ + 4 - (int)this.m_93517_();
            if (this.f_93398_) {
                this.m_7154_(ms, k, l, tessellator);
            }
            this.m_239227_(ms, p_render_1_, p_render_2_, p_render_3_);
            RenderSystem.m_69465_();
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.m_69472_();
            int j1 = this.m_93518_();
            if (j1 > 0) {
                int k1 = (int)((float)((this.f_93391_ - this.f_93390_) * (this.f_93391_ - this.f_93390_)) / (float)this.m_5775_());
                k1 = Mth.m_14045_((int)k1, (int)32, (int)(this.f_93391_ - this.f_93390_ - 8));
                int l1 = (int)this.m_93517_() * (this.f_93391_ - this.f_93390_ - k1) / j1 + this.f_93390_;
                if (l1 < this.f_93390_) {
                    l1 = this.f_93390_;
                }
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                bufferbuilder.m_5483_((double)i, (double)this.f_93391_, 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)this.f_93391_, 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)this.f_93390_, 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)this.f_93390_, 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
                tessellator.m_85914_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                bufferbuilder.m_5483_((double)i, (double)(l1 + k1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)(l1 + k1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)l1, 0.0).m_7421_(1.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)l1, 0.0).m_7421_(0.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
                tessellator.m_85914_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                bufferbuilder.m_5483_((double)i, (double)(l1 + k1 - 1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(192, 192, 192, 255).m_5752_();
                bufferbuilder.m_5483_((double)(j - 1), (double)(l1 + k1 - 1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(192, 192, 192, 255).m_5752_();
                bufferbuilder.m_5483_((double)(j - 1), (double)l1, 0.0).m_7421_(1.0f, 0.0f).m_6122_(192, 192, 192, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)l1, 0.0).m_7421_(0.0f, 0.0f).m_6122_(192, 192, 192, 255).m_5752_();
                tessellator.m_85914_();
            }
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
        }

        public int m_93518_() {
            return Math.max(0, this.m_5775_() - (this.f_93391_ - this.f_93390_ - 4));
        }

        @OnlyIn(value=Dist.CLIENT)
        public class ShaderTypeEntry
        extends ObjectSelectionList.Entry<ShaderTypeEntry> {
            private final ShaderType shaderType;

            public ShaderTypeEntry(ShaderType shaderType) {
                this.shaderType = shaderType;
            }

            public void m_6311_(PoseStack ms, int itemIndex, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                if (rowTop + 10 > ShaderTypeList.this.f_93390_ && rowTop + rowHeight - 5 < ShaderTypeList.this.f_93391_) {
                    GuiComponent.m_93243_((PoseStack)ms, (Font)PlayerSettingsGui.this.f_96547_, (Component)this.shaderType.name, (int)(ShaderTypeList.this.f_93393_ + 8), (int)(rowTop + 4), (int)0xFFFFFF);
                }
            }

            public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                if (p_mouseClicked_5_ == 0) {
                    ShaderTypeList.this.setSelected(this);
                    return true;
                }
                return false;
            }

            public Component m_142172_() {
                return null;
            }
        }
    }

    public static enum ShaderType {
        DISSOLVE_BLUE("Dissolve Blue"),
        DISSOLVE_ORANGE("Dissolve Orange");

        public Component name;

        private ShaderType(Component name) {
            this.name = name;
        }

        private ShaderType(String name) {
            this.name = Component.m_237113_((String)name);
        }
    }
}

