/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.utility.outliner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.create.foundation.render.RenderTypes;
import nl.requios.effortlessbuilding.create.foundation.render.SuperRenderTypeBuffer;
import nl.requios.effortlessbuilding.create.foundation.utility.outliner.Outline;

public class AABBOutline
extends Outline {
    protected AABB bb;

    public AABBOutline(AABB bb) {
        this.setBounds(bb);
    }

    @Override
    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, float pt) {
        this.renderBB(ms, buffer, this.bb);
    }

    public void renderBB(PoseStack ms, SuperRenderTypeBuffer buffer, AABB bb) {
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        boolean noCull = bb.m_82390_(projectedView);
        bb = bb.m_82400_(noCull ? -0.0078125 : 0.0078125);
        noCull |= this.params.disableCull;
        Vec3 xyz = new Vec3(bb.f_82288_, bb.f_82289_, bb.f_82290_);
        Vec3 Xyz = new Vec3(bb.f_82291_, bb.f_82289_, bb.f_82290_);
        Vec3 xYz = new Vec3(bb.f_82288_, bb.f_82292_, bb.f_82290_);
        Vec3 XYz = new Vec3(bb.f_82291_, bb.f_82292_, bb.f_82290_);
        Vec3 xyZ = new Vec3(bb.f_82288_, bb.f_82289_, bb.f_82293_);
        Vec3 XyZ = new Vec3(bb.f_82291_, bb.f_82289_, bb.f_82293_);
        Vec3 xYZ = new Vec3(bb.f_82288_, bb.f_82292_, bb.f_82293_);
        Vec3 XYZ = new Vec3(bb.f_82291_, bb.f_82292_, bb.f_82293_);
        Vec3 start = xyz;
        this.renderAACuboidLine(ms, buffer, start, Xyz);
        this.renderAACuboidLine(ms, buffer, start, xYz);
        this.renderAACuboidLine(ms, buffer, start, xyZ);
        start = XyZ;
        this.renderAACuboidLine(ms, buffer, start, xyZ);
        this.renderAACuboidLine(ms, buffer, start, XYZ);
        this.renderAACuboidLine(ms, buffer, start, Xyz);
        start = XYz;
        this.renderAACuboidLine(ms, buffer, start, xYz);
        this.renderAACuboidLine(ms, buffer, start, Xyz);
        this.renderAACuboidLine(ms, buffer, start, XYZ);
        start = xYZ;
        this.renderAACuboidLine(ms, buffer, start, XYZ);
        this.renderAACuboidLine(ms, buffer, start, xyZ);
        this.renderAACuboidLine(ms, buffer, start, xYz);
        this.renderFace(ms, buffer, Direction.NORTH, xYz, XYz, Xyz, xyz, noCull);
        this.renderFace(ms, buffer, Direction.SOUTH, XYZ, xYZ, xyZ, XyZ, noCull);
        this.renderFace(ms, buffer, Direction.EAST, XYz, XYZ, XyZ, Xyz, noCull);
        this.renderFace(ms, buffer, Direction.WEST, xYZ, xYz, xyz, xyZ, noCull);
        this.renderFace(ms, buffer, Direction.UP, xYZ, XYZ, XYz, xYz, noCull);
        this.renderFace(ms, buffer, Direction.DOWN, xyz, Xyz, XyZ, xyZ, noCull);
    }

    protected void renderFace(PoseStack ms, SuperRenderTypeBuffer buffer, Direction direction, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4, boolean noCull) {
        if (!this.params.faceTexture.isPresent()) {
            return;
        }
        ResourceLocation faceTexture = this.params.faceTexture.get().getLocation();
        float alphaBefore = this.params.alpha;
        this.params.alpha = direction == this.params.getHighlightedFace() && this.params.hightlightedFaceTexture.isPresent() ? 1.0f : 0.5f;
        RenderType translucentType = RenderTypes.getOutlineTranslucent(faceTexture, !noCull);
        VertexConsumer builder = buffer.getLateBuffer(translucentType);
        Direction.Axis axis = direction.m_122434_();
        Vec3 uDiff = p2.m_82546_(p1);
        Vec3 vDiff = p4.m_82546_(p1);
        float maxU = (float)Math.abs(axis == Direction.Axis.X ? uDiff.f_82481_ : uDiff.f_82479_);
        float maxV = (float)Math.abs(axis == Direction.Axis.Y ? vDiff.f_82481_ : vDiff.f_82480_);
        this.putQuadUV(ms, builder, p1, p2, p3, p4, 0.0f, 0.0f, maxU, maxV, Direction.UP);
        this.params.alpha = alphaBefore;
    }

    public void setBounds(AABB bb) {
        this.bb = bb;
    }
}

