/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.item.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import nl.requios.effortlessbuilding.create.foundation.render.RenderTypes;
import nl.requios.effortlessbuilding.create.foundation.utility.Iterate;

public class PartialItemModelRenderer {
    private static final PartialItemModelRenderer INSTANCE = new PartialItemModelRenderer();
    private final RandomSource random = RandomSource.m_216327_();
    private ItemStack stack;
    private ItemTransforms.TransformType transformType;
    private PoseStack ms;
    private MultiBufferSource buffer;
    private int overlay;

    public static PartialItemModelRenderer of(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack ms, MultiBufferSource buffer, int overlay) {
        PartialItemModelRenderer instance = INSTANCE;
        instance.stack = stack;
        instance.transformType = transformType;
        instance.ms = ms;
        instance.buffer = buffer;
        instance.overlay = overlay;
        return instance;
    }

    public void render(BakedModel model, int light) {
        this.render(model, RenderTypes.getItemPartialTranslucent(), light);
    }

    public void renderSolid(BakedModel model, int light) {
        this.render(model, RenderTypes.getItemPartialSolid(), light);
    }

    public void render(BakedModel model, RenderType type, int light) {
        if (this.stack.m_41619_()) {
            return;
        }
        this.ms.m_85836_();
        this.ms.m_85837_(-0.5, -0.5, -0.5);
        if (!model.m_7521_()) {
            VertexConsumer vc = ItemRenderer.m_115222_((MultiBufferSource)this.buffer, (RenderType)type, (boolean)true, (boolean)this.stack.m_41790_());
            for (BakedModel pass : model.getRenderPasses(this.stack, false)) {
                this.renderBakedItemModel(pass, light, this.ms, vc);
            }
        } else {
            IClientItemExtensions.of((ItemStack)this.stack).getCustomRenderer().m_108829_(this.stack, this.transformType, this.ms, this.buffer, light, this.overlay);
        }
        this.ms.m_85849_();
    }

    private void renderBakedItemModel(BakedModel model, int light, PoseStack ms, VertexConsumer buffer) {
        ItemRenderer ir = Minecraft.m_91087_().m_91291_();
        ModelData data = ModelData.EMPTY;
        for (RenderType renderType : model.getRenderTypes(this.stack, false)) {
            for (Direction direction : Iterate.directions) {
                this.random.m_188584_(42L);
                ir.m_115162_(ms, buffer, model.getQuads(null, direction, this.random, data, renderType), this.stack, light, this.overlay);
            }
            this.random.m_188584_(42L);
            ir.m_115162_(ms, buffer, model.getQuads(null, null, this.random, data, renderType), this.stack, light, this.overlay);
        }
    }
}

