/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmodifier.BaseModifier;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import nl.requios.effortlessbuilding.utilities.BlockSet;

public class Mirror
extends BaseModifier {
    public Vec3 position = new Vec3(0.5, 64.5, 0.5);
    public boolean mirrorX = true;
    public boolean mirrorY = false;
    public boolean mirrorZ = false;
    public int radius = 10;
    public boolean drawLines = true;
    public boolean drawPlanes = true;

    public Mirror() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            this.position = Vec3.m_82528_((Vec3i)Minecraft.m_91087_().f_91074_.m_20183_());
        }
    }

    @Override
    public void findCoordinates(BlockSet blocks, Player player) {
        if (!this.enabled || !this.mirrorX && !this.mirrorY && !this.mirrorZ) {
            return;
        }
        BlockSet originalBlocks = new BlockSet(blocks);
        for (BlockEntry blockEntry : originalBlocks) {
            if (!this.isWithinRange(blockEntry.blockPos)) continue;
            if (this.mirrorX) {
                this.performMirrorX(blocks, blockEntry);
            }
            if (this.mirrorY) {
                this.performMirrorY(blocks, blockEntry);
            }
            if (!this.mirrorZ) continue;
            this.performMirrorZ(blocks, blockEntry);
        }
    }

    @Override
    public void onPowerLevelChanged(int powerLevel) {
        this.radius = EffortlessBuildingClient.POWER_LEVEL.getMaxMirrorRadius((Player)Minecraft.m_91087_().f_91074_);
    }

    private void performMirrorX(BlockSet blocks, BlockEntry blockEntry) {
        double x = this.position.f_82479_ + (this.position.f_82479_ - (double)blockEntry.blockPos.m_123341_() - 0.5);
        BlockPos newBlockPos = new BlockPos(x, (double)blockEntry.blockPos.m_123342_(), (double)blockEntry.blockPos.m_123343_());
        if (blocks.containsKey(newBlockPos)) {
            return;
        }
        BlockEntry newBlockEntry = new BlockEntry(newBlockPos);
        newBlockEntry.copyRotationSettingsFrom(blockEntry);
        newBlockEntry.mirrorX = !newBlockEntry.mirrorX;
        blocks.add(newBlockEntry);
        if (this.mirrorY) {
            this.performMirrorY(blocks, newBlockEntry);
        }
        if (this.mirrorZ) {
            this.performMirrorZ(blocks, newBlockEntry);
        }
    }

    private void performMirrorY(BlockSet blocks, BlockEntry blockEntry) {
        double y = this.position.f_82480_ + (this.position.f_82480_ - (double)blockEntry.blockPos.m_123342_() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)blockEntry.blockPos.m_123341_(), y, (double)blockEntry.blockPos.m_123343_());
        if (blocks.containsKey(newBlockPos)) {
            return;
        }
        BlockEntry newBlockEntry = new BlockEntry(newBlockPos);
        newBlockEntry.copyRotationSettingsFrom(blockEntry);
        newBlockEntry.mirrorY = !newBlockEntry.mirrorY;
        blocks.add(newBlockEntry);
        if (this.mirrorZ) {
            this.performMirrorZ(blocks, newBlockEntry);
        }
    }

    private void performMirrorZ(BlockSet blocks, BlockEntry blockEntry) {
        double z = this.position.f_82481_ + (this.position.f_82481_ - (double)blockEntry.blockPos.m_123343_() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)blockEntry.blockPos.m_123341_(), (double)blockEntry.blockPos.m_123342_(), z);
        if (blocks.containsKey(newBlockPos)) {
            return;
        }
        BlockEntry newBlockEntry = new BlockEntry(newBlockPos);
        newBlockEntry.copyRotationSettingsFrom(blockEntry);
        newBlockEntry.mirrorZ = !newBlockEntry.mirrorZ;
        blocks.add(newBlockEntry);
    }

    public boolean isWithinRange(BlockPos blockPos) {
        return !((double)blockPos.m_123341_() + 0.5 < this.position.f_82479_ - (double)this.radius || (double)blockPos.m_123341_() + 0.5 > this.position.f_82479_ + (double)this.radius || (double)blockPos.m_123342_() + 0.5 < this.position.f_82480_ - (double)this.radius || (double)blockPos.m_123342_() + 0.5 > this.position.f_82480_ + (double)this.radius || (double)blockPos.m_123343_() + 0.5 < this.position.f_82481_ - (double)this.radius || (double)blockPos.m_123343_() + 0.5 > this.position.f_82481_ + (double)this.radius);
    }

    public int getReach() {
        return this.radius * 2;
    }

    public void toggleMirrorAxis(int index) {
        switch (index) {
            case 0: {
                this.mirrorX = !this.mirrorX;
                break;
            }
            case 1: {
                this.mirrorY = !this.mirrorY;
                break;
            }
            case 2: {
                this.mirrorZ = !this.mirrorZ;
            }
        }
    }

    public boolean getMirrorAxis(int index) {
        switch (index) {
            case 0: {
                return this.mirrorX;
            }
            case 1: {
                return this.mirrorY;
            }
            case 2: {
                return this.mirrorZ;
            }
        }
        return false;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128347_("positionX", this.position.f_82479_);
        compound.m_128347_("positionY", this.position.f_82480_);
        compound.m_128347_("positionZ", this.position.f_82481_);
        compound.m_128379_("mirrorX", this.mirrorX);
        compound.m_128379_("mirrorY", this.mirrorY);
        compound.m_128379_("mirrorZ", this.mirrorZ);
        compound.m_128405_("radius", this.radius);
        compound.m_128379_("drawLines", this.drawLines);
        compound.m_128379_("drawPlanes", this.drawPlanes);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.position = new Vec3(compound.m_128459_("positionX"), compound.m_128459_("positionY"), compound.m_128459_("positionZ"));
        this.mirrorX = compound.m_128471_("mirrorX");
        this.mirrorY = compound.m_128471_("mirrorY");
        this.mirrorZ = compound.m_128471_("mirrorZ");
        this.radius = compound.m_128451_("radius");
        this.drawLines = compound.m_128471_("drawLines");
        this.drawPlanes = compound.m_128471_("drawPlanes");
    }
}

