/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmode.BuildModeEnum;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.gui.buildmode.PlayerSettingsGui;
import nl.requios.effortlessbuilding.gui.buildmode.RadialMenu;
import nl.requios.effortlessbuilding.gui.buildmodifier.ModifiersScreen;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    public static KeyMapping[] keyBindings;
    public static int ticksInGame;
    private static int placeCooldown;
    private static int breakCooldown;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Screen gui;
        if (!ClientEvents.isGameActive()) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            EffortlessBuildingClient.BUILDER_CHAIN.onTick();
            ClientEvents.onMouseInput();
            EffortlessBuildingClient.BLOCK_PREVIEWS.onTick();
        } else if (!(event.phase != TickEvent.Phase.END || (gui = Minecraft.m_91087_().f_91080_) != null && gui.m_7043_())) {
            ++ticksInGame;
        }
    }

    private static void onMouseInput() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        BuildModeEnum buildMode = EffortlessBuildingClient.BUILD_MODES.getBuildMode();
        if (mc.f_91080_ != null || RadialMenu.instance.isVisible()) {
            return;
        }
        if (mc.f_91066_.f_92095_.m_90857_()) {
            if (placeCooldown <= 0) {
                placeCooldown = 4;
                EffortlessBuildingClient.BUILDER_CHAIN.onRightClick();
            } else if (buildMode == BuildModeEnum.SINGLE) {
                --placeCooldown;
                if (ModeOptions.getBuildSpeed() == ModeOptions.ActionEnum.FAST_SPEED) {
                    placeCooldown = 0;
                }
            }
        } else {
            placeCooldown = 0;
        }
        if (mc.f_91066_.f_92096_.m_90857_()) {
            if (breakCooldown <= 0) {
                breakCooldown = 4;
                EffortlessBuildingClient.BUILDER_CHAIN.onLeftClick();
            } else if (buildMode == BuildModeEnum.SINGLE) {
                --breakCooldown;
                if (ModeOptions.getBuildSpeed() == ModeOptions.ActionEnum.FAST_SPEED) {
                    breakCooldown = 0;
                }
            }
        } else {
            breakCooldown = 0;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onKeyPress(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (keyBindings[0].m_90857_()) {
            if (!EffortlessBuildingClient.POWER_LEVEL.isDisabled((Player)player)) {
                if (!RadialMenu.instance.isVisible()) {
                    Minecraft.m_91087_().m_91152_((Screen)RadialMenu.instance);
                }
            } else {
                EffortlessBuilding.log((Player)player, "Build modes are disabled until your reach has increased. Increase your reach with craftable reach upgrades.");
            }
        }
        if (keyBindings[1].m_90859_()) {
            ClientEvents.openModifierSettings();
        }
        if (keyBindings[2].m_90859_()) {
            ModeOptions.performAction((Player)player, ModeOptions.ActionEnum.UNDO);
        }
        if (keyBindings[3].m_90859_()) {
            ModeOptions.performAction((Player)player, ModeOptions.ActionEnum.REDO);
        }
        if (keyBindings[4].m_90859_()) {
            ModeOptions.performAction((Player)player, ModeOptions.ActionEnum.PREVIOUS_BUILD_MODE);
        }
        if (keyBindings[5].m_90859_()) {
            ModeOptions.performAction((Player)player, ModeOptions.ActionEnum.DISABLE_BUILD_MODE_TOGGLE);
        }
    }

    public static void openModifierSettings() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (EffortlessBuildingClient.POWER_LEVEL.isDisabled((Player)player)) {
            EffortlessBuilding.log((Player)player, "Build modifiers are disabled until your power level has increased. Increase your power level by consuming certain items.");
        } else {
            mc.m_91152_((Screen)new ModifiersScreen());
        }
    }

    public static void openPlayerSettings() {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new PlayerSettingsGui());
    }

    @SubscribeEvent
    public static void onGuiOpen(ScreenEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            EffortlessBuildingClient.BUILDER_CHAIN.cancel();
        }
    }

    public static boolean isKeybindDown(int keybindIndex) {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keyBindings[keybindIndex].getKey().m_84873_());
    }

    public static boolean isGameActive() {
        return Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null;
    }

    static {
        ticksInGame = 0;
        placeCooldown = 0;
        breakCooldown = 0;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            keyBindings = new KeyMapping[6];
            ClientEvents.keyBindings[0] = new KeyMapping("key.effortlessbuilding.mode.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.m_84827_((int)342, (int)0), "key.effortlessbuilding.category");
            ClientEvents.keyBindings[1] = new KeyMapping("key.effortlessbuilding.hud.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.m_84827_((int)334, (int)0), "key.effortlessbuilding.category");
            ClientEvents.keyBindings[2] = new KeyMapping("key.effortlessbuilding.undo.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputConstants.m_84827_((int)90, (int)0), "key.effortlessbuilding.category");
            ClientEvents.keyBindings[3] = new KeyMapping("key.effortlessbuilding.redo.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputConstants.m_84827_((int)89, (int)0), "key.effortlessbuilding.category");
            ClientEvents.keyBindings[4] = new KeyMapping("key.effortlessbuilding.previous_build_mode.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "key.effortlessbuilding.category");
            ClientEvents.keyBindings[5] = new KeyMapping("key.effortlessbuilding.disable_build_mode_toggle.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "key.effortlessbuilding.category");
            for (KeyMapping keyBinding : keyBindings) {
                event.register(keyBinding);
            }
        }
    }
}

