/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import org.mtr.core.data.Depot;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockDriverKeyDispenser;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.item.ItemDriverKey;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderDriverKeyDispenser
extends BlockEntityRenderer<BlockDriverKeyDispenser.BlockEntity> {
    private static final double ROTATION_OFFSET = Math.sqrt(2.0) / 2.0;
    private static final double ROTATION_SCALE = 14.0 / ROTATION_OFFSET / 16.0 / 2.0;
    private static final int ROTATION_DURATION = 5000;

    public RenderDriverKeyDispenser(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    @Override
    public void render(BlockDriverKeyDispenser.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        Depot depot = InitClient.findDepot(blockEntity.getPos2());
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)blockEntity.getPos2().getX(), blockEntity.getPos2().getY(), 0.5 + (double)blockEntity.getPos2().getZ());
        if (depot == null) {
            MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/white.png"), false, QueuedRenderLayer.INTERIOR, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                graphicsHolderNew.translate(0.0, 0.5, 0.0);
                InitClient.transformToFacePlayer(graphicsHolderNew, (double)blockEntity.getPos2().getX() + 0.5, (double)blockEntity.getPos2().getY() + 0.5, (double)blockEntity.getPos2().getZ() + 0.5);
                graphicsHolderNew.rotateZDegrees(45.0f);
                graphicsHolderNew.scale((float)ROTATION_SCALE, (float)ROTATION_SCALE, 1.0f);
                IDrawing.drawTexture(graphicsHolderNew, -0.0625f, -0.5f, 0.125f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.UP, -65536, GraphicsHolder.getDefaultLight());
                IDrawing.drawTexture(graphicsHolderNew, -0.5f, -0.0625f, 1.0f, 0.125f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.UP, -65536, GraphicsHolder.getDefaultLight());
                graphicsHolderNew.pop();
            });
        } else {
            IntArrayList colors = new IntArrayList();
            if (blockEntity.getDispenseBasicDriverKey()) {
                colors.add(((ItemDriverKey)Items.BASIC_DRIVER_KEY.get().data).color);
            }
            if (blockEntity.getDispenseAdvancedDriverKey()) {
                colors.add(((ItemDriverKey)Items.ADVANCED_DRIVER_KEY.get().data).color);
            }
            if (blockEntity.getDispenseGuardKey()) {
                colors.add(((ItemDriverKey)Items.GUARD_KEY.get().data).color);
            }
            if (!colors.isEmpty()) {
                MainRenderer.scheduleRender(new Identifier("mtr", "textures/item/driver_key.png"), false, QueuedRenderLayer.INTERIOR, (graphicsHolderNew, offset) -> {
                    Vector3d offsetVector;
                    storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                    graphicsHolderNew.translate(0.0, 0.5, 0.0);
                    InitClient.transformToFacePlayer(graphicsHolderNew, (double)blockEntity.getPos2().getX() + 0.5, (double)blockEntity.getPos2().getY() + 0.5, (double)blockEntity.getPos2().getZ() + 0.5);
                    graphicsHolderNew.rotateZDegrees(180.0f);
                    if (colors.size() > 1) {
                        graphicsHolderNew.scale((float)ROTATION_SCALE / 2.0f, (float)ROTATION_SCALE / 2.0f, 1.0f);
                        offsetVector = new Vector3d(ROTATION_OFFSET, 0.0, 0.0);
                    } else {
                        graphicsHolderNew.scale((float)ROTATION_SCALE, (float)ROTATION_SCALE, 1.0f);
                        offsetVector = Vector3d.getZeroMapped();
                    }
                    for (int i = 0; i < colors.size(); ++i) {
                        Vector3d newOffsetVector = offsetVector.rotateZ((float)(Math.PI * 2 * (double)((float)i / (float)colors.size() + (float)(System.currentTimeMillis() % 5000L) / 5000.0f)));
                        IDrawing.drawTexture(graphicsHolderNew, (float)newOffsetVector.getXMapped() - 0.5f, (float)newOffsetVector.getYMapped() - 0.5f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.DOWN, 0xFF000000 | colors.getInt(i), GraphicsHolder.getDefaultLight());
                    }
                    graphicsHolderNew.pop();
                });
            }
        }
    }
}

