/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.core.data.VehicleRidingEntity;
import org.mtr.core.operation.UpdateVehicleRidingEntities;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;
import org.mtr.mod.packet.PacketRequestResponseBase;

public final class PacketUpdateVehicleRidingEntities
extends PacketRequestResponseBase
implements Utilities {
    private final boolean dismount;

    public static PacketUpdateVehicleRidingEntities create(long sidingId, long vehicleId, int ridingCar, double x, double y, double z, boolean isOnGangway, boolean isDriver, boolean manualAccelerate, boolean manualBrake, boolean manualToggleDoors, boolean manualToggleAto, boolean doorOverride) {
        UpdateVehicleRidingEntities updateVehicleRidingEntities = new UpdateVehicleRidingEntities(sidingId, vehicleId);
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity != null) {
            updateVehicleRidingEntities.add(new VehicleRidingEntity(clientPlayerEntity.getUuid(), (long)ridingCar, x, y, z, isOnGangway, isDriver, manualAccelerate, manualBrake, manualToggleDoors, manualToggleAto, doorOverride));
        }
        return new PacketUpdateVehicleRidingEntities(Utilities.getJsonObjectFromData(updateVehicleRidingEntities).toString(), ridingCar < 0);
    }

    public PacketUpdateVehicleRidingEntities(PacketBufferReceiver packetBufferReceiver) {
        super(packetBufferReceiver);
        this.dismount = packetBufferReceiver.readBoolean();
    }

    private PacketUpdateVehicleRidingEntities(String content, boolean dismount) {
        super(content);
        this.dismount = dismount;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        super.write(packetBufferSender);
        packetBufferSender.writeBoolean(this.dismount);
    }

    @Override
    protected void runServerOutbound(ServerWorld serverWorld, @Nullable ServerPlayerEntity serverPlayerEntity) {
        super.runServerOutbound(serverWorld, serverPlayerEntity);
        if (serverPlayerEntity != null) {
            Init.updateRidingEntity(serverPlayerEntity, this.dismount);
        }
    }

    @Override
    protected PacketRequestResponseBase getInstance(String content) {
        return new PacketUpdateVehicleRidingEntities(content, this.dismount);
    }

    @Override
    protected SerializedDataBase getDataInstance(JsonReader jsonReader) {
        return new UpdateVehicleRidingEntities(jsonReader);
    }

    @Override
    @Nonnull
    protected String getKey() {
        return "update_riding_entities";
    }

    @Override
    protected PacketRequestResponseBase.ResponseType responseType() {
        return PacketRequestResponseBase.ResponseType.NONE;
    }
}

