/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import javax.annotation.Nullable;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class ScrollingText
implements IGui {
    private float ticksOffset;
    private DynamicTextureCache.DynamicResource dynamicResource;
    private final double availableWidth;
    private final double availableHeight;
    private final int scrollSpeed;
    private final boolean isFullPixel;

    public ScrollingText(double availableWidth, double availableHeight, int scrollSpeed, boolean isFullPixel) {
        this.availableWidth = availableWidth;
        this.availableHeight = availableHeight;
        this.scrollSpeed = scrollSpeed;
        this.isFullPixel = isFullPixel;
    }

    public void changeImage(@Nullable DynamicTextureCache.DynamicResource dynamicResource) {
        if (this.dynamicResource != dynamicResource) {
            this.dynamicResource = dynamicResource;
            this.ticksOffset = InitClient.getGameTick();
        }
    }

    public void scrollText(StoredMatrixTransformations storedMatrixTransformations) {
        if (this.dynamicResource != null) {
            int pixelScale = this.isFullPixel ? 1 : 4;
            double scale = this.availableHeight / (double)this.dynamicResource.height;
            int widthSteps = (int)Math.floor(this.availableWidth / scale / (double)pixelScale);
            int imageSteps = this.dynamicResource.width / pixelScale;
            int totalSteps = widthSteps + imageSteps;
            int step = Math.round((InitClient.getGameTick() - this.ticksOffset) * (float)this.scrollSpeed) % totalSteps;
            double width = Math.min(Math.min(this.availableWidth, (double)this.dynamicResource.width * scale), Math.min((double)(step * pixelScale) * scale, (double)((totalSteps - step) * pixelScale) * scale));
            MainRenderer.scheduleRender(this.dynamicResource.identifier, true, QueuedRenderLayer.LIGHT_2, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolder, (float)((double)Math.max(widthSteps - step, 0) * scale * (double)pixelScale), 0.0f, (float)width, (float)this.availableHeight, Math.max((float)(step - widthSteps) / (float)imageSteps, 0.0f), 0.0f, Math.min((float)step / (float)imageSteps, 1.0f), 1.0f, Direction.UP, -1, GraphicsHolder.getDefaultLight());
                graphicsHolder.pop();
            });
        }
    }
}

