/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mod.Init;

public final class StrayThreadManager {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private static final int SLEEP_TIME = 5000;

    public static void register(MinecraftServer minecraftServer) {
        EXECUTOR_SERVICE.execute(() -> {
            try {
                do {
                    Thread.sleep(5000L);
                } while (minecraftServer.isRunning());
                Init.LOGGER.info("Server is no longer running, stopping thread monitoring.");
                Thread.sleep(5000L);
                StrayThreadManager.forceShutdownStrayThreads();
            }
            catch (InterruptedException e) {
                Init.LOGGER.warn("Watch thread interrupted", (Throwable)e);
            }
            finally {
                Init.LOGGER.info("Shutting down watch thread executor.");
                EXECUTOR_SERVICE.shutdown();
            }
        });
    }

    private static void forceShutdownStrayThreads() {
        Init.LOGGER.info("Attempting to shutdown stray threads...");
        for (Thread thread2 : Thread.getAllStackTraces().keySet()) {
            if (thread2.isDaemon()) continue;
            Init.LOGGER.info("Interrupting thread [{}]", (Object)thread2.getName());
            thread2.interrupt();
        }
        Init.LOGGER.info("All non-daemon threads have been interrupted. Forcing server shutdown...");
        Runtime.getRuntime().halt(0);
    }
}

