/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Matrix4f;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mapping.render.batch.BatchManager;
import org.mtr.mapping.render.shader.ModShaderHandler;
import org.mtr.mapping.render.shader.ShaderManager;
import org.mtr.mapping.render.tool.GlStateTracker;
import org.mtr.mapping.render.tool.Utilities;
import org.mtr.mapping.render.vertex.VertexAttributeState;
import org.mtr.mapping.tool.DummyClass;

public final class OptimizedRenderer
extends DummyClass {
    private final BatchManager batchManager = new BatchManager();
    private final ShaderManager shaderManager = new ShaderManager();

    @MappedMethod
    public void beginReload() {
        this.shaderManager.reloadShaders();
        GlStateTracker.capture();
    }

    @MappedMethod
    public void finishReload() {
        GlStateTracker.restore();
    }

    @MappedMethod
    public void queue(OptimizedModel optimizedModel, GraphicsHolder graphicsHolder, int color, int light) {
        if (graphicsHolder.matrixStack != null) {
            this.batchManager.queue(optimizedModel.uploadedParts, new VertexAttributeState(color, light, Utilities.copy(new Matrix4f(graphicsHolder.matrixStack.m_85850_().m_85861_()))));
        }
    }

    @MappedMethod
    public void render(boolean renderTranslucent) {
        if (this.shaderManager.isReady()) {
            GlStateTracker.capture();
            this.batchManager.drawAll(this.shaderManager, renderTranslucent);
            GlStateTracker.restore();
        }
    }

    @MappedMethod
    public static boolean renderingShadows() {
        return ModShaderHandler.renderingShadows();
    }

    @MappedMethod
    public static boolean hasOptimizedRendering() {
        return true;
    }
}

