/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.oba;

import javax.annotation.Nonnull;
import org.mtr.core.oba.Frequency;
import org.mtr.core.oba.OccupancyStatus;
import org.mtr.core.oba.TripStatus;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class ArrivalAndDepartureSchema
implements SerializedDataBase {
    protected final String routeId;
    protected final String tripId;
    protected final long serviceDate;
    protected final String stopId;
    protected final long stopSequence;
    protected final long totalStopsInTrip;
    protected final long blockTripSequence;
    protected final String routeShortName;
    protected final String routeLongName;
    protected final String tripHeadsign;
    protected final boolean arrivalEnabled;
    protected final boolean departureEnabled;
    protected final long scheduledArrivalTime;
    protected final long scheduledDepartureTime;
    protected Frequency frequency = this.getDefaultFrequency();
    protected final boolean predicted;
    protected final long predictedArrivalTime;
    protected final long predictedDepartureTime;
    protected final double distanceFromStop;
    protected final OccupancyStatus historicalOccupancy;
    protected final long numberOfStopsAway;
    protected final OccupancyStatus occupancyStatus;
    protected final ObjectArrayList<String> situationIds = new ObjectArrayList();
    protected final String status;
    protected TripStatus tripStatus = this.getDefaultTripStatus();
    protected final String vehicleId;

    protected ArrivalAndDepartureSchema(String routeId, String tripId, long serviceDate, String stopId, long stopSequence, long totalStopsInTrip, long blockTripSequence, String routeShortName, String routeLongName, String tripHeadsign, boolean arrivalEnabled, boolean departureEnabled, long scheduledArrivalTime, long scheduledDepartureTime, boolean predicted, long predictedArrivalTime, long predictedDepartureTime, double distanceFromStop, OccupancyStatus historicalOccupancy, long numberOfStopsAway, OccupancyStatus occupancyStatus, String status, String vehicleId) {
        this.routeId = routeId;
        this.tripId = tripId;
        this.serviceDate = serviceDate;
        this.stopId = stopId;
        this.stopSequence = stopSequence;
        this.totalStopsInTrip = totalStopsInTrip;
        this.blockTripSequence = blockTripSequence;
        this.routeShortName = routeShortName;
        this.routeLongName = routeLongName;
        this.tripHeadsign = tripHeadsign;
        this.arrivalEnabled = arrivalEnabled;
        this.departureEnabled = departureEnabled;
        this.scheduledArrivalTime = scheduledArrivalTime;
        this.scheduledDepartureTime = scheduledDepartureTime;
        this.predicted = predicted;
        this.predictedArrivalTime = predictedArrivalTime;
        this.predictedDepartureTime = predictedDepartureTime;
        this.distanceFromStop = distanceFromStop;
        this.historicalOccupancy = historicalOccupancy;
        this.numberOfStopsAway = numberOfStopsAway;
        this.occupancyStatus = occupancyStatus;
        this.status = status;
        this.vehicleId = vehicleId;
    }

    protected ArrivalAndDepartureSchema(ReaderBase readerBase) {
        this.routeId = readerBase.getString("routeId", "");
        this.tripId = readerBase.getString("tripId", "");
        this.serviceDate = readerBase.getLong("serviceDate", 0L);
        this.stopId = readerBase.getString("stopId", "");
        this.stopSequence = readerBase.getLong("stopSequence", 0L);
        this.totalStopsInTrip = readerBase.getLong("totalStopsInTrip", 0L);
        this.blockTripSequence = readerBase.getLong("blockTripSequence", 0L);
        this.routeShortName = readerBase.getString("routeShortName", "");
        this.routeLongName = readerBase.getString("routeLongName", "");
        this.tripHeadsign = readerBase.getString("tripHeadsign", "");
        this.arrivalEnabled = readerBase.getBoolean("arrivalEnabled", false);
        this.departureEnabled = readerBase.getBoolean("departureEnabled", false);
        this.scheduledArrivalTime = readerBase.getLong("scheduledArrivalTime", 0L);
        this.scheduledDepartureTime = readerBase.getLong("scheduledDepartureTime", 0L);
        this.predicted = readerBase.getBoolean("predicted", false);
        this.predictedArrivalTime = readerBase.getLong("predictedArrivalTime", 0L);
        this.predictedDepartureTime = readerBase.getLong("predictedDepartureTime", 0L);
        this.distanceFromStop = readerBase.getDouble("distanceFromStop", 0.0);
        this.historicalOccupancy = EnumHelper.valueOf(OccupancyStatus.values()[0], readerBase.getString("historicalOccupancy", ""));
        this.numberOfStopsAway = readerBase.getLong("numberOfStopsAway", 0L);
        this.occupancyStatus = EnumHelper.valueOf(OccupancyStatus.values()[0], readerBase.getString("occupancyStatus", ""));
        this.status = readerBase.getString("status", "");
        this.vehicleId = readerBase.getString("vehicleId", "");
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.unpackChild("frequency", readerBaseChild -> {
            this.frequency = new Frequency((ReaderBase)readerBaseChild);
        });
        readerBase.iterateStringArray("situationIds", this.situationIds::clear, this.situationIds::add);
        readerBase.unpackChild("tripStatus", readerBaseChild -> {
            this.tripStatus = new TripStatus((ReaderBase)readerBaseChild);
        });
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        writerBase.writeString("routeId", this.routeId);
        writerBase.writeString("tripId", this.tripId);
        writerBase.writeLong("serviceDate", this.serviceDate);
        writerBase.writeString("stopId", this.stopId);
        writerBase.writeLong("stopSequence", this.stopSequence);
        writerBase.writeLong("totalStopsInTrip", this.totalStopsInTrip);
        writerBase.writeLong("blockTripSequence", this.blockTripSequence);
        writerBase.writeString("routeShortName", this.routeShortName);
        writerBase.writeString("routeLongName", this.routeLongName);
        writerBase.writeString("tripHeadsign", this.tripHeadsign);
        writerBase.writeBoolean("arrivalEnabled", this.arrivalEnabled);
        writerBase.writeBoolean("departureEnabled", this.departureEnabled);
        writerBase.writeLong("scheduledArrivalTime", this.scheduledArrivalTime);
        writerBase.writeLong("scheduledDepartureTime", this.scheduledDepartureTime);
        this.serializeFrequency(writerBase);
        writerBase.writeBoolean("predicted", this.predicted);
        writerBase.writeLong("predictedArrivalTime", this.predictedArrivalTime);
        writerBase.writeLong("predictedDepartureTime", this.predictedDepartureTime);
        writerBase.writeDouble("distanceFromStop", this.distanceFromStop);
        writerBase.writeString("historicalOccupancy", this.historicalOccupancy.toString());
        writerBase.writeLong("numberOfStopsAway", this.numberOfStopsAway);
        writerBase.writeString("occupancyStatus", this.occupancyStatus.toString());
        this.serializeSituationIds(writerBase);
        writerBase.writeString("status", this.status);
        this.serializeTripStatus(writerBase);
        writerBase.writeString("vehicleId", this.vehicleId);
    }

    @Nonnull
    public String toString() {
        return "routeId: " + this.routeId + "\ntripId: " + this.tripId + "\nserviceDate: " + this.serviceDate + "\nstopId: " + this.stopId + "\nstopSequence: " + this.stopSequence + "\ntotalStopsInTrip: " + this.totalStopsInTrip + "\nblockTripSequence: " + this.blockTripSequence + "\nrouteShortName: " + this.routeShortName + "\nrouteLongName: " + this.routeLongName + "\ntripHeadsign: " + this.tripHeadsign + "\narrivalEnabled: " + this.arrivalEnabled + "\ndepartureEnabled: " + this.departureEnabled + "\nscheduledArrivalTime: " + this.scheduledArrivalTime + "\nscheduledDepartureTime: " + this.scheduledDepartureTime + "\nfrequency: " + this.frequency + "\npredicted: " + this.predicted + "\npredictedArrivalTime: " + this.predictedArrivalTime + "\npredictedDepartureTime: " + this.predictedDepartureTime + "\ndistanceFromStop: " + this.distanceFromStop + "\nhistoricalOccupancy: " + (Object)((Object)this.historicalOccupancy) + "\nnumberOfStopsAway: " + this.numberOfStopsAway + "\noccupancyStatus: " + (Object)((Object)this.occupancyStatus) + "\nsituationIds: " + this.situationIds + "\nstatus: " + this.status + "\ntripStatus: " + this.tripStatus + "\nvehicleId: " + this.vehicleId + "\n";
    }

    protected abstract Frequency getDefaultFrequency();

    protected void serializeFrequency(WriterBase writerBase) {
        if (this.frequency != null) {
            this.frequency.serializeData(writerBase.writeChild("frequency"));
        }
    }

    protected void serializeSituationIds(WriterBase writerBase) {
        WriterBase.Array situationIdsWriterBaseArray = writerBase.writeArray("situationIds");
        this.situationIds.forEach(situationIdsWriterBaseArray::writeString);
    }

    protected abstract TripStatus getDefaultTripStatus();

    protected void serializeTripStatus(WriterBase writerBase) {
        if (this.tripStatus != null) {
            this.tripStatus.serializeData(writerBase.writeChild("tripStatus"));
        }
    }
}

