/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.map;

import javax.annotation.Nonnull;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class StationSchema
implements SerializedDataBase {
    protected final String id;
    protected final String name;
    protected final long color;
    protected final long zone1;
    protected final long zone2;
    protected final long zone3;
    protected final ObjectArrayList<String> connections = new ObjectArrayList();

    protected StationSchema(String id, String name, long color, long zone1, long zone2, long zone3) {
        this.id = id;
        this.name = name;
        this.color = color;
        this.zone1 = zone1;
        this.zone2 = zone2;
        this.zone3 = zone3;
    }

    protected StationSchema(ReaderBase readerBase) {
        this.id = readerBase.getString("id", "");
        this.name = readerBase.getString("name", "");
        this.color = readerBase.getLong("color", 0L);
        this.zone1 = readerBase.getLong("zone1", 0L);
        this.zone2 = readerBase.getLong("zone2", 0L);
        this.zone3 = readerBase.getLong("zone3", 0L);
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.iterateStringArray("connections", this.connections::clear, this.connections::add);
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        writerBase.writeString("id", this.id);
        writerBase.writeString("name", this.name);
        writerBase.writeLong("color", this.color);
        writerBase.writeLong("zone1", this.zone1);
        writerBase.writeLong("zone2", this.zone2);
        writerBase.writeLong("zone3", this.zone3);
        this.serializeConnections(writerBase);
    }

    @Nonnull
    public String toString() {
        return "id: " + this.id + "\nname: " + this.name + "\ncolor: " + this.color + "\nzone1: " + this.zone1 + "\nzone2: " + this.zone2 + "\nzone3: " + this.zone3 + "\nconnections: " + this.connections + "\n";
    }

    protected void serializeConnections(WriterBase writerBase) {
        WriterBase.Array connectionsWriterBaseArray = writerBase.writeArray("connections");
        this.connections.forEach(connectionsWriterBaseArray::writeString);
    }
}

