/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.ModItemGroups;
import de.maxhenkel.car.blocks.BlockPaint;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.gui.ContainerPainter;
import de.maxhenkel.car.gui.SlotPainter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkHooks;

public class ItemPainter
extends Item {
    private final boolean isYellow;

    public ItemPainter(boolean isYellow) {
        super(new Item.Properties().m_41487_(1).m_41503_(1024).m_41491_(ModItemGroups.TAB_CAR));
        this.isYellow = isYellow;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_60734_() instanceof BlockPaint) {
            return 50.0f;
        }
        return super.m_8102_(stack, state);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, final Player playerIn, final InteractionHand handIn) {
        if (playerIn.m_6144_() && playerIn instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return ItemPainter.this.m_7626_(playerIn.m_21120_(handIn));
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                    return new ContainerPainter(i, playerInventory, ItemPainter.this.isYellow);
                }
            }, packetBuffer -> packetBuffer.writeBoolean(this.isYellow));
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_().m_6144_()) {
            return InteractionResult.PASS;
        }
        if (!context.m_43719_().equals((Object)Direction.UP)) {
            return InteractionResult.FAIL;
        }
        if (!BlockPaint.canPlaceBlockAt(context.m_43725_(), context.m_8083_().m_7494_())) {
            return InteractionResult.FAIL;
        }
        if (!context.m_43725_().m_46859_(context.m_8083_().m_7494_())) {
            return InteractionResult.FAIL;
        }
        ItemStack stack1 = context.m_43722_();
        if (stack1.m_41619_() || !(stack1.m_41720_() instanceof ItemPainter)) {
            return InteractionResult.FAIL;
        }
        BlockPaint block = this.getSelectedPaint(SlotPainter.getPainterID(stack1));
        if (block == null) {
            return InteractionResult.FAIL;
        }
        BlockState state = (BlockState)block.m_49966_().m_61124_((Property)BlockPaint.FACING, (Comparable)context.m_43723_().m_6350_());
        context.m_43725_().m_46597_(context.m_8083_().m_7494_(), state);
        stack1.m_41622_(1, (LivingEntity)context.m_43723_(), playerEntity -> playerEntity.m_21190_(context.m_43724_()));
        return InteractionResult.SUCCESS;
    }

    private BlockPaint getSelectedPaint(int id) {
        if (id < 0 || id >= ModBlocks.PAINTS.length) {
            return null;
        }
        BlockPaint block = this.isYellow ? (BlockPaint)ModBlocks.YELLOW_PAINTS[id].get() : (BlockPaint)ModBlocks.PAINTS[id].get();
        return block;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> textComponents, TooltipFlag tooltipFlag) {
        BlockPaint paint = this.getSelectedPaint(SlotPainter.getPainterID(stack));
        if (paint != null) {
            textComponents.add((Component)Component.m_237110_((String)"tooltip.painter", (Object[])new Object[]{Component.m_237115_((String)paint.m_7705_()).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, world, textComponents, tooltipFlag);
    }
}

