/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.integration.jei;

import de.maxhenkel.car.integration.jei.CarRecipe;
import de.maxhenkel.car.items.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class CarRecipeBuilder {
    public static List<CarRecipe> getAllRecipes() {
        ArrayList<CarRecipe> recipes = new ArrayList<CarRecipe>();
        ItemStack wheel = new ItemStack((ItemLike)ModItems.WHEEL.get());
        ItemStack largeWheel = new ItemStack((ItemLike)ModItems.BIG_WHEEL.get());
        for (ItemStack tank : CarRecipeBuilder.getAllTanks()) {
            for (ItemStack engine : CarRecipeBuilder.getAllEngines()) {
                for (ItemStack plate : CarRecipeBuilder.getAllLicensePlateHolders()) {
                    for (ItemStack bumper : CarRecipeBuilder.getAllBumpers()) {
                        for (ItemStack body : CarRecipeBuilder.getWoodBodies()) {
                            recipes.add(new CarRecipe(body, bumper, plate, tank, engine, wheel, wheel, wheel, wheel));
                        }
                    }
                    for (ItemStack body : CarRecipeBuilder.getSUVBodies()) {
                        recipes.add(new CarRecipe(body, plate, tank, engine, largeWheel, largeWheel, largeWheel, largeWheel));
                    }
                    for (ItemStack body : CarRecipeBuilder.getSportBodies()) {
                        recipes.add(new CarRecipe(body, plate, tank, engine, wheel, wheel, wheel, wheel));
                    }
                    for (ItemStack container : CarRecipeBuilder.getAllContainers()) {
                        for (ItemStack body : CarRecipeBuilder.getTransporters()) {
                            recipes.add(new CarRecipe(body, container, plate, tank, engine, wheel, wheel, wheel, wheel, wheel, wheel));
                        }
                    }
                    for (ItemStack container : CarRecipeBuilder.getAllTankContainers()) {
                        for (ItemStack body : CarRecipeBuilder.getTransporters()) {
                            recipes.add(new CarRecipe(body, container, plate, tank, engine, wheel, wheel, wheel, wheel, wheel, wheel));
                        }
                    }
                }
            }
        }
        return recipes;
    }

    public static List<ItemStack> getWoodBodies() {
        return CarRecipeBuilder.concatItems(ModItems.BIG_WOOD_BODIES, ModItems.WOOD_BODIES);
    }

    public static List<ItemStack> getTransporters() {
        return CarRecipeBuilder.concatItems(new RegistryObject[][]{ModItems.TRANSPORTER_BODIES});
    }

    public static List<ItemStack> getSUVBodies() {
        return CarRecipeBuilder.concatItems(new RegistryObject[][]{ModItems.SUV_BODIES});
    }

    public static List<ItemStack> getSportBodies() {
        return CarRecipeBuilder.concatItems(new RegistryObject[][]{ModItems.SPORT_BODIES});
    }

    public static List<ItemStack> getAllBodies() {
        return CarRecipeBuilder.concatItems(ModItems.BIG_WOOD_BODIES, ModItems.WOOD_BODIES, ModItems.SPORT_BODIES, ModItems.SUV_BODIES, ModItems.TRANSPORTER_BODIES);
    }

    public static List<ItemStack> getAllWoodBodies() {
        return CarRecipeBuilder.concatItems(new RegistryObject[][]{ModItems.WOOD_BODIES});
    }

    public static List<ItemStack> getAllBigWoodBodies() {
        return CarRecipeBuilder.concatItems(new RegistryObject[][]{ModItems.BIG_WOOD_BODIES});
    }

    public static List<ItemStack> getAllBumpers() {
        return CarRecipeBuilder.concatItems(new RegistryObject[][]{ModItems.BUMPERS});
    }

    public static List<ItemStack> getAllContainers() {
        return CarRecipeBuilder.concatItems(new RegistryObject[][]{ModItems.CONTAINERS});
    }

    public static List<ItemStack> getAllTankContainers() {
        return CarRecipeBuilder.concatItems(new RegistryObject[][]{ModItems.TANK_CONTAINERS});
    }

    public static List<ItemStack> getAllLicensePlateHolders() {
        List<ItemStack> bumpers = CarRecipeBuilder.concatItems(new RegistryObject[][]{ModItems.WOODEN_LICENSE_PLATE_HOLDERS});
        bumpers.add(new ItemStack((ItemLike)ModItems.IRON_LICENSE_PLATE_HOLDER.get()));
        bumpers.add(new ItemStack((ItemLike)ModItems.GOLD_LICENSE_PLATE_HOLDER.get()));
        bumpers.add(new ItemStack((ItemLike)ModItems.EMERALD_LICENSE_PLATE_HOLDER.get()));
        bumpers.add(new ItemStack((ItemLike)ModItems.DIAMOND_LICENSE_PLATE_HOLDER.get()));
        return bumpers;
    }

    public static List<ItemStack> getAllEngines() {
        return Arrays.asList(new ItemStack((ItemLike)ModItems.ENGINE_3_CYLINDER.get()), new ItemStack((ItemLike)ModItems.ENGINE_6_CYLINDER.get()), new ItemStack((ItemLike)ModItems.ENGINE_TRUCK.get()));
    }

    public static List<ItemStack> getAllTanks() {
        return Arrays.asList(new ItemStack((ItemLike)ModItems.SMALL_TANK.get()), new ItemStack((ItemLike)ModItems.MEDIUM_TANK.get()), new ItemStack((ItemLike)ModItems.LARGE_TANK.get()));
    }

    public static <T extends Item> List<ItemStack> concatItems(RegistryObject<T>[] ... items) {
        return CarRecipeBuilder.concatArrays(items).stream().map(RegistryObject::get).map(ItemStack::new).collect(Collectors.toList());
    }

    private static <T> List<T> concatArrays(T[] ... arrays) {
        ArrayList list = new ArrayList();
        for (T[] array : arrays) {
            Collections.addAll(list, array);
        }
        return list;
    }
}

