/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import com.mojang.math.Vector3d;
import de.maxhenkel.car.Main;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityVehicleBase
extends Entity {
    public static float SCALE_FACTOR = 0.7f;
    private int steps;
    private double clientX;
    private double clientY;
    private double clientZ;
    private double clientYaw;
    private double clientPitch;
    protected float deltaRotation;

    public EntityVehicleBase(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.f_19850_ = true;
        this.f_19793_ = 0.6f;
        this.recalculateBoundingBox();
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            this.f_19854_ = this.m_20185_();
            this.f_19855_ = this.m_20186_();
            this.f_19856_ = this.m_20189_();
        }
        super.m_8119_();
        this.tickLerp();
        this.recalculateBoundingBox();
    }

    public void recalculateBoundingBox() {
        double width = this.getCarWidth();
        double height = this.getCarHeight();
        this.m_20011_(new AABB(this.m_20185_() - width / 2.0, this.m_20186_(), this.m_20189_() - width / 2.0, this.m_20185_() + width / 2.0, this.m_20186_() + height, this.m_20189_() + width / 2.0));
    }

    public double getCarWidth() {
        return 1.3;
    }

    public double getCarHeight() {
        return 1.6;
    }

    public Player getDriver() {
        List passengers = this.m_20197_();
        if (passengers.size() <= 0) {
            return null;
        }
        if (passengers.get(0) instanceof Player) {
            return (Player)passengers.get(0);
        }
        return null;
    }

    public abstract int getPassengerSize();

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < this.getPassengerSize();
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-130.0f, (float)130.0f);
        entityToUpdate.f_19859_ += f1 - f;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + f1 - f);
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7340_(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public abstract Vector3d[] getPlayerOffsets();

    public void m_7332_(Entity passenger) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        double front = 0.0;
        double side = 0.0;
        double height = 0.0;
        List passengers = this.m_20197_();
        if (passengers.size() > 0) {
            int i = passengers.indexOf(passenger);
            Vector3d offset = this.getPlayerOffsets()[i];
            front = offset.f_86214_;
            side = offset.f_86216_;
            height = offset.f_86215_;
        }
        Vec3 vec3d = new Vec3(front, height, side).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        passenger.m_6034_(this.m_20185_() + vec3d.f_82479_, this.m_20186_() + vec3d.f_82480_, this.m_20189_() + vec3d.f_82481_);
        passenger.m_146922_(passenger.m_146908_() + this.deltaRotation);
        passenger.m_5616_(passenger.m_6080_() + this.deltaRotation);
        this.applyYawToEntity(passenger);
    }

    public Entity m_6688_() {
        return this.getDriver();
    }

    public boolean m_7337_(Entity entity) {
        if (!((Boolean)Main.SERVER_CONFIG.collideWithEntities.get()).booleanValue() && !(entity instanceof EntityVehicleBase)) {
            return false;
        }
        return (entity.m_5829_() || entity.m_6094_()) && !this.m_20365_(entity);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.steps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.steps > 0) {
            double d0 = this.m_20185_() + (this.clientX - this.m_20185_()) / (double)this.steps;
            double d1 = this.m_20186_() + (this.clientY - this.m_20186_()) / (double)this.steps;
            double d2 = this.m_20189_() + (this.clientZ - this.m_20189_()) / (double)this.steps;
            double d3 = Mth.m_14175_((double)(this.clientYaw - (double)this.m_146908_()));
            this.m_146922_((float)((double)this.m_146908_() + d3 / (double)this.steps));
            this.m_146926_((float)((double)this.m_146909_() + (this.clientPitch - (double)this.m_146909_()) / (double)this.steps));
            --this.steps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.clientX = x;
        this.clientY = y;
        this.clientZ = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.steps = 10;
    }

    public static double calculateMotionX(float speed, float rotationYaw) {
        return Mth.m_14031_((float)(-rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public static double calculateMotionZ(float speed, float rotationYaw) {
        return Mth.m_14089_((float)(rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!player.m_6144_()) {
            if (player.m_20202_() != this && !this.f_19853_.f_46443_) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public abstract boolean doesEnterThirdPerson();

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public Vec3 m_7688_(LivingEntity entity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(entity);
        }
        int[][] offsets = DismountHelper.m_38467_((Direction)direction);
        AABB bb = entity.m_21270_(Pose.STANDING);
        AABB carBB = this.m_20191_();
        for (int[] offset : offsets) {
            Vec3 dismountPos = new Vec3(this.m_20185_() + (double)offset[0] * (carBB.m_82362_() / 2.0 + bb.m_82362_() / 2.0 + 0.0625), this.m_20186_(), this.m_20189_() + (double)offset[1] * (carBB.m_82362_() / 2.0 + bb.m_82362_() / 2.0 + 0.0625));
            double y = this.f_19853_.m_45573_(new BlockPos(dismountPos));
            if (!DismountHelper.m_38439_((double)y) || !DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)entity, (AABB)bb.m_82383_(dismountPos))) continue;
            return dismountPos;
        }
        return super.m_7688_(entity);
    }
}

