/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import de.maxhenkel.car.corelib.client.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class TileEntitySpecialRendererTank
implements BlockEntityRenderer<TileEntityTank> {
    public static final ResourceLocation LOCATION_TANK = new ResourceLocation("car", "textures/block/tank_line.png");
    protected BlockEntityRendererProvider.Context renderer;

    public TileEntitySpecialRendererTank(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
    }

    public void render(TileEntityTank te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        matrixStack.m_85836_();
        float amount = te.getFillPercent();
        FluidStack stack = te.getFluid();
        if (amount > 0.0f && stack != null) {
            this.renderFluid(te, stack, amount, 0.0f, matrixStack, buffer, light, overlay);
        }
        TileEntitySpecialRendererTank.renderLines(te, matrixStack, buffer, light, overlay);
        matrixStack.m_85849_();
    }

    public void renderFluid(TileEntityTank tank, FluidStack fluid, float amount, float yStart, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        ResourceLocation stillTexture;
        int tint;
        matrixStack.m_85836_();
        VertexConsumer builder = buffer.m_6299_(Sheets.m_110792_());
        IClientFluidTypeExtensions type = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        if (tank.m_58898_()) {
            tint = type.getTintColor(fluid.getFluid().m_76145_(), (BlockAndTintGetter)tank.m_58904_(), tank.m_58899_());
            stillTexture = type.getStillTexture(fluid.getFluid().m_76145_(), (BlockAndTintGetter)tank.m_58904_(), tank.m_58899_());
        } else {
            tint = type.getTintColor(fluid);
            stillTexture = type.getStillTexture(fluid);
        }
        TextureAtlasSprite texture = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(stillTexture);
        float uMin = texture.m_118409_();
        float uMax = texture.m_118410_();
        float vMin = texture.m_118411_();
        float vMax = texture.m_118412_();
        float vHeight = vMax - vMin;
        int red = tint >> 16 & 0xFF;
        int green = tint >> 8 & 0xFF;
        int blue = tint & 0xFF;
        float s = 0.0f;
        if (!tank.isFluidConnected(Direction.NORTH)) {
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f - s, yStart, 0.0f + s, uMin, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.SOUTH)) {
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMax, vMin, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.EAST)) {
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMin, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMax, vMin, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.WEST)) {
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.DOWN)) {
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMin, vMax, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 0.0f + s, uMax, vMax, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.UP)) {
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMax, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMax, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
        }
        matrixStack.m_85849_();
    }

    public static void renderLines(TileEntityTank te, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)LOCATION_TANK));
        for (Direction facing : Direction.values()) {
            if (te.isTankConnectedTo(facing)) continue;
            for (EnumDirection direction : EnumDirection.values()) {
                if (te.isTankConnectedTo(direction.to(facing))) continue;
                TileEntitySpecialRendererTank.drawLine(facing, direction, matrixStack, buffer, builder, light, overlay);
            }
        }
    }

    public static void drawLine(Direction side, EnumDirection line, PoseStack matrixStack, MultiBufferSource buffer, VertexConsumer builder, int light, int overlay) {
        matrixStack.m_85836_();
        TileEntitySpecialRendererTank.rotate(side, matrixStack);
        matrixStack.m_85837_(-2.5E-4, -2.5E-4, -2.5E-4);
        TileEntitySpecialRendererTank.drawSide(line, side, matrixStack, buffer, builder, light, overlay);
        matrixStack.m_85849_();
    }

    public static void rotate(Direction facing, PoseStack matrixStack) {
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        switch (facing) {
            case SOUTH: {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                break;
            }
            case EAST: {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
                break;
            }
            case WEST: {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                break;
            }
            case UP: {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                break;
            }
            case DOWN: {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(270.0f));
                break;
            }
        }
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
    }

    public static void drawSide(EnumDirection line, Direction side, PoseStack matrixStack, MultiBufferSource buffer, VertexConsumer builder, int light, int overlay) {
        switch (line) {
            case UP: {
                RenderUtils.vertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                break;
            }
            case DOWN: {
                RenderUtils.vertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                break;
            }
            case RIGHT: {
                RenderUtils.vertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                break;
            }
            case LEFT: {
                RenderUtils.vertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                break;
            }
        }
    }

    public static enum EnumDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;


        public Direction to(Direction facing) {
            switch (facing) {
                case NORTH: {
                    switch (this) {
                        case UP: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.DOWN;
                        }
                        case LEFT: {
                            return Direction.EAST;
                        }
                        case RIGHT: {
                            return Direction.WEST;
                        }
                    }
                }
                case SOUTH: {
                    switch (this) {
                        case UP: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.DOWN;
                        }
                        case LEFT: {
                            return Direction.WEST;
                        }
                        case RIGHT: {
                            return Direction.EAST;
                        }
                    }
                }
                case EAST: {
                    switch (this) {
                        case UP: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.DOWN;
                        }
                        case LEFT: {
                            return Direction.SOUTH;
                        }
                        case RIGHT: {
                            return Direction.NORTH;
                        }
                    }
                }
                case WEST: {
                    switch (this) {
                        case UP: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.DOWN;
                        }
                        case LEFT: {
                            return Direction.NORTH;
                        }
                        case RIGHT: {
                            return Direction.SOUTH;
                        }
                    }
                }
                case UP: {
                    switch (this) {
                        case UP: {
                            return Direction.NORTH;
                        }
                        case DOWN: {
                            return Direction.SOUTH;
                        }
                        case LEFT: {
                            return Direction.WEST;
                        }
                        case RIGHT: {
                            return Direction.EAST;
                        }
                    }
                }
                case DOWN: {
                    switch (this) {
                        case UP: {
                            return Direction.SOUTH;
                        }
                        case DOWN: {
                            return Direction.NORTH;
                        }
                        case LEFT: {
                            return Direction.WEST;
                        }
                        case RIGHT: {
                            return Direction.EAST;
                        }
                    }
                }
            }
            return Direction.UP;
        }
    }
}

