/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.display;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import me.srrapero720.watermedia.api.math.MathAPI;
import me.srrapero720.watermedia.api.player.PlayerAPI;
import me.srrapero720.watermedia.api.player.SyncVideoPlayer;
import net.minecraft.client.Minecraft;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.display.FramePictureDisplay;

public class FrameVideoDisplay
extends FrameDisplay {
    private static final int ACCEPTABLE_SYNC_TIME = 1000;
    private static final List<FrameVideoDisplay> OPEN_DISPLAYS = new ArrayList<FrameVideoDisplay>();
    public SyncVideoPlayer player;
    private final Vec3d pos;
    private boolean stream = false;
    private volatile float lastSetVolume;
    private long lastCorrectedTime = Long.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            for (FrameVideoDisplay display : OPEN_DISPLAYS) {
                if (!Minecraft.m_91087_().m_91104_()) continue;
                if (display.stream) {
                    if (!display.player.isPlaying()) continue;
                    display.player.setPauseMode(true);
                    continue;
                }
                if (display.player.getDuration() <= 0L || !display.player.isPlaying()) continue;
                display.player.setPauseMode(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unload() {
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            for (FrameVideoDisplay display : OPEN_DISPLAYS) {
                display.free();
            }
            OPEN_DISPLAYS.clear();
        }
    }

    public static FrameDisplay createVideoDisplay(Vec3d pos, String url, float volume, float minDistance, float maxDistance, boolean loop) {
        if (PlayerAPI.isReady()) {
            FrameVideoDisplay display = new FrameVideoDisplay(pos, url, volume, minDistance, maxDistance, loop);
            OPEN_DISPLAYS.add(display);
            return display;
        }
        return FramePictureDisplay.VLC_FAILED;
    }

    public FrameVideoDisplay(Vec3d pos, String url, float volume, float minDistance, float maxDistance, boolean loop) {
        this.pos = pos;
        this.player = new SyncVideoPlayer((Executor)Minecraft.m_91087_());
        float tempVolume = this.getVolume(volume, minDistance, maxDistance);
        this.player.setVolume((int)tempVolume);
        this.lastSetVolume = tempVolume;
        this.player.setRepeatMode(loop);
        this.player.start((CharSequence)url);
    }

    public int getVolume(float volume, float minDistance, float maxDistance) {
        if (this.player == null) {
            return 0;
        }
        float distance = (float)this.pos.distance(Minecraft.m_91087_().f_91074_.m_20318_(CreativeCoreClient.getFrameTime()));
        if (minDistance > maxDistance) {
            float temp = maxDistance;
            maxDistance = minDistance;
            minDistance = temp;
        }
        if (distance > minDistance) {
            volume = distance > maxDistance ? 0.0f : (volume *= 1.0f - (distance - minDistance) / (maxDistance - minDistance));
        }
        return (int)(volume * 100.0f);
    }

    @Override
    public void tick(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        if ((volume = (float)this.getVolume(volume, minDistance, maxDistance)) != this.lastSetVolume) {
            this.player.setVolume((int)volume);
            this.lastSetVolume = volume;
        }
        if (this.player.isValid()) {
            boolean realPlaying;
            boolean bl = realPlaying = playing && !Minecraft.m_91087_().m_91104_();
            if (this.player.getRepeatMode() != loop) {
                this.player.setRepeatMode(loop);
            }
            long tickTime = 50L;
            this.stream = this.player.isLive();
            if (this.stream) {
                if (this.player.isPlaying() != realPlaying) {
                    this.player.setPauseMode(!realPlaying);
                }
            } else if (this.player.getDuration() > 0L) {
                if (this.player.isPlaying() != realPlaying) {
                    this.player.setPauseMode(!realPlaying);
                }
                if (this.player.isSeekAble()) {
                    long time = (long)tick * tickTime + (realPlaying ? (long)(CreativeCoreClient.getFrameTime() * (float)tickTime) : 0L);
                    if (time > this.player.getTime() && loop) {
                        time %= this.player.getDuration();
                    }
                    if (Math.abs(time - this.player.getTime()) > 1000L && Math.abs(time - this.lastCorrectedTime) > 1000L) {
                        this.lastCorrectedTime = time;
                        this.player.seekTo(time);
                    }
                }
            }
        }
    }

    @Override
    public int prepare(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return -1;
        }
        return this.player.getGlTexture();
    }

    public void free() {
        if (this.player != null) {
            SyncVideoPlayer tempPlayer = this.player;
            tempPlayer.release();
        }
        this.player = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.free();
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            OPEN_DISPLAYS.remove(this);
        }
    }

    @Override
    public void pause(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.player.seekTo(MathAPI.tickToMs((int)tick));
        this.player.pause();
    }

    @Override
    public void resume(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.player.seekTo(MathAPI.tickToMs((int)tick));
        this.player.play();
    }

    @Override
    public int getWidth() {
        return this.player.getWidth();
    }

    @Override
    public int getHeight() {
        return this.player.getHeight();
    }

    @Override
    public boolean canTick() {
        return this.player != null && this.player.isSafeUse();
    }
}

