/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.audiodevice.SelectMicrophoneScreen;
import de.maxhenkel.voicechat.gui.audiodevice.SelectSpeakerScreen;
import de.maxhenkel.voicechat.gui.widgets.AgcButton;
import de.maxhenkel.voicechat.gui.widgets.DenoiserButton;
import de.maxhenkel.voicechat.gui.widgets.EnumButton;
import de.maxhenkel.voicechat.gui.widgets.KeybindButton;
import de.maxhenkel.voicechat.gui.widgets.MicActivationButton;
import de.maxhenkel.voicechat.gui.widgets.MicAmplificationSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.gui.widgets.VadButton;
import de.maxhenkel.voicechat.gui.widgets.VoiceActivationSlider;
import de.maxhenkel.voicechat.gui.widgets.VoiceSoundSlider;
import de.maxhenkel.voicechat.natives.SpeexManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.speaker.AudioType;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class VoiceChatSettingsScreen
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_voicechat_settings.png");
    private static final Component TITLE = Component.m_237115_((String)"gui.voicechat.voice_chat_settings.title");
    private static final Component ASSIGN_TOOLTIP = Component.m_237115_((String)"message.voicechat.press_to_reassign_key");
    private static final Component PUSH_TO_TALK = Component.m_237115_((String)"message.voicechat.activation_type.ptt");
    private static final Component SELECT_MICROPHONE = Component.m_237115_((String)"message.voicechat.select_microphone");
    private static final Component SELECT_SPEAKER = Component.m_237115_((String)"message.voicechat.select_speaker");
    private static final Component BACK = Component.m_237115_((String)"message.voicechat.back");
    @Nullable
    private final Screen parent;
    private VoiceActivationSlider voiceActivationSlider;
    private MicTestButton micTestButton;
    private KeybindButton keybindButton;

    public VoiceChatSettingsScreen(@Nullable Screen parent) {
        super(TITLE, 248, 219);
        this.parent = parent;
    }

    public VoiceChatSettingsScreen() {
        this(null);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int y = this.guiTop + 20;
        this.m_142416_((GuiEventListener)new VoiceSoundSlider(this.guiLeft + 10, y, this.xSize - 20, 20));
        boolean agc = SpeexManager.canUseAgc();
        MicAmplificationSlider micAmp = new MicAmplificationSlider(this, this.guiLeft + 10 + (agc ? 81 : 0), y += 21, this.xSize - 20 - (agc ? 80 : 0) - 1, 20);
        if (agc) {
            this.m_142416_((GuiEventListener)new AgcButton(this, this.guiLeft + 10, y, 80, 20, active -> micAmp.setActive(active == false)));
        }
        this.m_142416_((GuiEventListener)micAmp);
        this.m_142416_((GuiEventListener)new DenoiserButton(this.guiLeft + 10, y += 21, this.xSize - 20, 20));
        this.voiceActivationSlider = new VoiceActivationSlider(this.guiLeft + 10, (y += 21) + 42, this.xSize - 20, 20);
        VadButton vadButton = new VadButton(this.guiLeft + 10, y + 21, this.xSize - 20, 20);
        this.micTestButton = new MicTestButton(this.guiLeft + 10, y, false, this.voiceActivationSlider);
        this.keybindButton = new KeybindButton(KeyEvents.KEY_PTT, this.guiLeft + 10, y + 21, this.xSize - 20, 20, PUSH_TO_TALK);
        this.m_142416_((GuiEventListener)new MicActivationButton(this.guiLeft + 10 + 20 + 1, y, this.xSize - 20 - 20 - 1, 20, type -> {
            vadButton.f_93624_ = MicrophoneActivationType.VOICE.equals(type);
            this.keybindButton.f_93624_ = MicrophoneActivationType.PTT.equals(type);
            this.keybindButton.resetListening();
        }));
        this.m_142416_((GuiEventListener)this.micTestButton);
        this.m_142416_((GuiEventListener)vadButton);
        this.m_142416_((GuiEventListener)this.voiceActivationSlider);
        this.m_142416_((GuiEventListener)this.keybindButton);
        this.m_142416_((GuiEventListener)new EnumButton<AudioType>(this.guiLeft + 10, y += 63, this.xSize - 20, 20, VoicechatClient.CLIENT_CONFIG.audioType){

            @Override
            protected Component getText(AudioType type) {
                return Component.m_237110_((String)"message.voicechat.audio_type", (Object[])new Object[]{type.getText()});
            }

            @Override
            protected void onUpdate(AudioType type) {
                ClientVoicechat client = ClientManager.getClient();
                if (client != null) {
                    VoiceChatSettingsScreen.this.micTestButton.stop();
                    client.reloadAudio();
                }
            }
        });
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + 10, y += 21, (this.xSize - 20) / 2 - 1, 20, SELECT_MICROPHONE, button -> this.f_96541_.m_91152_((Screen)new SelectMicrophoneScreen(this))));
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + this.xSize / 2 + 2, y, (this.xSize - 20) / 2 - 1, 20, SELECT_SPEAKER, button -> this.f_96541_.m_91152_((Screen)new SelectSpeakerScreen(this))));
        y += 21;
        if (!this.isIngame() && this.parent != null) {
            this.m_142416_((GuiEventListener)new Button(this.guiLeft + 10, y, this.xSize - 20, 20, BACK, button -> this.f_96541_.m_91152_(this.parent)));
        }
    }

    @Override
    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        if (this.isIngame()) {
            this.m_93228_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        }
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        int titleWidth = this.f_96547_.m_92852_((FormattedText)TITLE);
        this.f_96547_.m_92877_(poseStack, TITLE.m_7532_(), (float)(this.guiLeft + (this.xSize - titleWidth) / 2), (float)(this.guiTop + 7), this.getFontColor());
        Component sliderTooltip = this.voiceActivationSlider.getHoverText();
        if (this.voiceActivationSlider.isHovered() && sliderTooltip != null) {
            this.m_96602_(poseStack, sliderTooltip, mouseX, mouseY);
        } else if (this.micTestButton.isHovered()) {
            this.micTestButton.m_7428_(poseStack, mouseX, mouseY);
        } else if (this.keybindButton.isHovered()) {
            this.m_96602_(poseStack, ASSIGN_TOOLTIP, mouseX, mouseY);
        }
    }

    public boolean m_6913_() {
        if (this.keybindButton.isListening()) {
            return false;
        }
        return super.m_6913_();
    }
}

