/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.recipes;

import com.devbobcorn.nekoration.entities.WallPaperEntity;
import com.devbobcorn.nekoration.items.ModItems;
import com.devbobcorn.nekoration.recipes.ModRecipes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class WallPaperRecipe
extends CustomRecipe {
    public WallPaperRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        ItemStack resultStack = ItemStack.f_41583_;
        ItemStack bannerStack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack curStack = inv.m_8020_(i);
            if (curStack.m_41619_()) continue;
            if (curStack.m_41720_() instanceof BannerItem) {
                if (!bannerStack.m_41619_()) {
                    return false;
                }
                bannerStack = curStack;
                continue;
            }
            if (curStack.m_41720_() != ModItems.WALLPAPER.get()) {
                return false;
            }
            if (!resultStack.m_41619_()) {
                return false;
            }
            CompoundTag tag = curStack.m_41737_("BlockEntityTag");
            if (tag != null && (WallPaperEntity.getBaseColor(tag) != DyeColor.WHITE || WallPaperEntity.getPatterns(tag) != null)) {
                return false;
            }
            resultStack = curStack;
        }
        return !resultStack.m_41619_() && !bannerStack.m_41619_();
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack bannerStack = ItemStack.f_41583_;
        ItemStack resultStack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack curStack = inv.m_8020_(i);
            if (curStack.m_41619_()) continue;
            if (curStack.m_41720_() instanceof BannerItem) {
                bannerStack = curStack;
                continue;
            }
            if (curStack.m_41720_() != ModItems.WALLPAPER.get()) continue;
            resultStack = curStack.m_41777_();
            resultStack.m_41764_(1);
        }
        if (resultStack.m_41619_()) {
            return resultStack;
        }
        CompoundTag bannerTag = bannerStack.m_41737_("BlockEntityTag");
        CompoundTag wallpaperTag = bannerTag == null ? new CompoundTag() : bannerTag.m_6426_();
        wallpaperTag.m_128405_("Base", ((BannerItem)bannerStack.m_41720_()).m_40545_().m_41060_());
        resultStack.m_41700_("BlockEntityTag", (Tag)wallpaperTag);
        return resultStack;
    }

    public boolean m_8004_(int w, int h) {
        return w * h >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.NEKO_WALLPAPER.get();
    }
}

