/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.recipes;

import com.devbobcorn.nekoration.recipes.ModRecipes;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class NekoShapedRecipe
extends CustomRecipe
implements IShapedRecipe<CraftingContainer> {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    private final int width;
    private final int height;
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack result;
    private final String group;

    public static void setCraftingSize(int width, int height) {
        if (MAX_WIDTH < width) {
            MAX_WIDTH = width;
        }
        if (MAX_HEIGHT < height) {
            MAX_HEIGHT = height;
        }
    }

    public NekoShapedRecipe(ResourceLocation id, String group, int w, int h, NonNullList<Ingredient> in, ItemStack out) {
        super(id);
        this.group = group;
        this.width = w;
        this.height = h;
        this.recipeItems = in;
        this.result = out;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.NEKO_SHAPED.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public boolean m_8004_(int w, int h) {
        return w >= this.width && h >= this.height;
    }

    public boolean matches(CraftingContainer inv, Level world) {
        for (int i = 0; i <= inv.m_39347_() - this.width; ++i) {
            for (int j = 0; j <= inv.m_39346_() - this.height; ++j) {
                if (this.matches(inv, i, j, true)) {
                    return true;
                }
                if (!this.matches(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer inv, int a, int b, boolean mirrored) {
        for (int i = 0; i < inv.m_39347_(); ++i) {
            for (int j = 0; j < inv.m_39346_(); ++j) {
                int k = i - a;
                int l = j - b;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirrored ? (Ingredient)this.recipeItems.get(this.width - k - 1 + l * this.width) : (Ingredient)this.recipeItems.get(k + l * this.width);
                }
                if (ingredient.test(inv.m_8020_(i + j * inv.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inv) {
        return this.result.m_41777_();
    }

    public int getWidth() {
        return this.width;
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }

    private static NonNullList<Ingredient> dissolvePattern(String[] pattern, Map<String, Ingredient> ingredients, int width, int height) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(ingredients.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = ingredients.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + width * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... recipe) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < recipe.length; ++i1) {
            String s = recipe[i1];
            i = Math.min(i, NekoShapedRecipe.firstNonSpace(s));
            int j1 = NekoShapedRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (recipe.length == l) {
            return new String[0];
        }
        String[] astring = new String[recipe.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = recipe[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String line) {
        int i;
        for (i = line.length() - 1; i >= 0 && line.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray arr) {
        String[] astring = new String[arr.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)arr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static Map<String, Ingredient> keyFromJson(JsonObject obj) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : obj.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static ItemStack itemFromJson(JsonObject obj) {
        if (obj.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        return CraftingHelper.getItemStack((JsonObject)obj, (boolean)true);
    }

    public List<List<ItemStack>> getInputs() {
        ArrayList<List<ItemStack>> slots = new ArrayList<List<ItemStack>>();
        for (Ingredient ingredient : this.recipeItems) {
            ArrayList<ItemStack> variants = new ArrayList<ItemStack>();
            for (ItemStack ingrediantStack : ingredient.m_43908_()) {
                variants.add(ingrediantStack.m_41777_());
            }
            slots.add(variants);
        }
        return slots;
    }

    public List<ItemStack> getOutputs() {
        ArrayList<ItemStack> variants = new ArrayList<ItemStack>();
        variants.add(this.result.m_41777_());
        return variants;
    }

    public static class Serializer
    implements RecipeSerializer<NekoShapedRecipe> {
        public NekoShapedRecipe fromJson(ResourceLocation id, JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> ingredientKeys = NekoShapedRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] astring = NekoShapedRecipe.shrink(NekoShapedRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList<Ingredient> nonnulllist = NekoShapedRecipe.dissolvePattern(astring, ingredientKeys, i, j);
            ItemStack itemstack = NekoShapedRecipe.itemFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new NekoShapedRecipe(id, s, i, j, nonnulllist, itemstack);
        }

        public NekoShapedRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf packet) {
            int i = packet.m_130242_();
            int j = packet.m_130242_();
            String s = packet.m_130136_(Short.MAX_VALUE);
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)packet));
            }
            ItemStack itemstack = packet.m_130267_();
            return new NekoShapedRecipe(id, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(FriendlyByteBuf packet, NekoShapedRecipe recipe) {
            packet.m_130130_(recipe.width);
            packet.m_130130_(recipe.height);
            packet.m_130070_(recipe.group);
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(packet);
            }
            packet.m_130055_(recipe.result);
        }
    }
}

