/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.entities.WallPaperEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class S2CUpdateWallpaperPart {
    private static final Logger LOGGER = LogManager.getLogger((String)"Wallpaper Part Packet");
    public int wallpaperId;
    public byte part;

    public S2CUpdateWallpaperPart(int id, byte p) {
        this.wallpaperId = id;
        this.part = p;
    }

    public static void encode(S2CUpdateWallpaperPart msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.wallpaperId);
        packetBuffer.writeByte((int)msg.part);
    }

    public static S2CUpdateWallpaperPart decode(FriendlyByteBuf packetBuffer) {
        int id = packetBuffer.readInt();
        byte p = packetBuffer.readByte();
        return new S2CUpdateWallpaperPart(id, p);
    }

    public static void handle(S2CUpdateWallpaperPart msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            Entity entity = world.m_6815_(msg.wallpaperId);
            if (entity instanceof WallPaperEntity) {
                WallPaperEntity we = (WallPaperEntity)entity;
                we.setPart(WallPaperEntity.Part.fromId(msg.part));
                LOGGER.info("Wallpaper part " + msg.wallpaperId + " updated to " + msg.part);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

