/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.NekoConfig;
import com.devbobcorn.nekoration.entities.PaintingEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class S2CUpdatePaintingData {
    private static final Logger LOGGER = LogManager.getLogger((String)"Painting Data Packet");
    public int paintingId;
    public byte partX;
    public byte partY;
    public byte partW;
    public byte partH;
    public int[] pixels;
    public int compositeHash;

    public S2CUpdatePaintingData(int id, byte x, byte y, byte w, byte h, int[] p, int hash) {
        this.paintingId = id;
        this.partX = x;
        this.partY = y;
        this.partW = w;
        this.partH = h;
        this.pixels = p;
        this.compositeHash = hash;
    }

    public static void encode(S2CUpdatePaintingData msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.paintingId);
        packetBuffer.writeByte((int)msg.partX);
        packetBuffer.writeByte((int)msg.partY);
        packetBuffer.writeByte((int)msg.partW);
        packetBuffer.writeByte((int)msg.partH);
        packetBuffer.m_130089_(msg.pixels);
        packetBuffer.writeInt(msg.compositeHash);
    }

    public static S2CUpdatePaintingData decode(FriendlyByteBuf packetBuffer) {
        int id = packetBuffer.readInt();
        byte x = packetBuffer.readByte();
        byte y = packetBuffer.readByte();
        byte w = packetBuffer.readByte();
        byte h = packetBuffer.readByte();
        int[] p = packetBuffer.m_130100_();
        int hash = packetBuffer.readInt();
        return new S2CUpdatePaintingData(id, x, y, w, h, p, hash);
    }

    public static void handle(S2CUpdatePaintingData msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            Entity entity = world.m_6815_(msg.paintingId);
            if (entity instanceof PaintingEntity) {
                PaintingEntity pe = (PaintingEntity)entity;
                if (pe.data.getPaintingHash() != msg.compositeHash) {
                    pe.data.clearCache(pe.data.getPaintingHash());
                    pe.data.setAreaPixels(msg.partX, msg.partY, msg.partW, msg.partH, msg.pixels);
                    boolean synced = pe.data.getPaintingHash() == msg.compositeHash;
                    LOGGER.info(String.format("Painting %s Synced: %s", msg.compositeHash, synced));
                    if (synced && ((Boolean)NekoConfig.CLIENT.useImageRendering.get()).booleanValue()) {
                        pe.data.cache();
                    }
                }
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

