/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.blocks.entities.CustomBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class S2CUpdateCustomBlockData {
    public BlockPos pos = BlockPos.f_121853_;
    public byte dir = 0;
    public int offsetX;
    public int offsetY;
    public int offsetZ;
    public boolean retint;
    public boolean showHint;
    public int red;
    public int green;
    public int blue;
    public BlockState displayState;

    public S2CUpdateCustomBlockData(BlockPos pos, byte dir, int[] offset, boolean retint, boolean showHint, int[] color, BlockState state) {
        this.pos = pos;
        this.dir = dir;
        this.offsetX = offset[0];
        this.offsetY = offset[1];
        this.offsetZ = offset[2];
        this.retint = retint;
        this.showHint = showHint;
        this.red = color[0];
        this.green = color[1];
        this.blue = color[2];
        this.displayState = state;
    }

    public static void encode(S2CUpdateCustomBlockData msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130064_(msg.pos);
        packetBuffer.writeByte((int)msg.dir);
        packetBuffer.writeInt(msg.offsetX);
        packetBuffer.writeInt(msg.offsetY);
        packetBuffer.writeInt(msg.offsetZ);
        packetBuffer.writeBoolean(msg.retint);
        packetBuffer.writeBoolean(msg.showHint);
        packetBuffer.writeInt(msg.red);
        packetBuffer.writeInt(msg.green);
        packetBuffer.writeInt(msg.blue);
        packetBuffer.m_130079_(NbtUtils.m_129202_((BlockState)msg.displayState));
    }

    public static S2CUpdateCustomBlockData decode(FriendlyByteBuf packetBuffer) {
        BlockPos pos = packetBuffer.m_130135_();
        byte dir = packetBuffer.readByte();
        int[] offset = new int[3];
        for (int i = 0; i < 3; ++i) {
            offset[i] = packetBuffer.readInt();
        }
        boolean retint = packetBuffer.readBoolean();
        boolean showHint = packetBuffer.readBoolean();
        int[] color = new int[3];
        for (int i = 0; i < 3; ++i) {
            color[i] = packetBuffer.readInt();
        }
        BlockState state = NbtUtils.m_129241_((CompoundTag)packetBuffer.m_130260_());
        return new S2CUpdateCustomBlockData(pos, dir, offset, retint, showHint, color, state);
    }

    public static void handle(S2CUpdateCustomBlockData msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            BlockEntity tileEntity;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world.m_46749_(msg.pos) && (tileEntity = world.m_7702_(msg.pos)) instanceof CustomBlockEntity) {
                CustomBlockEntity te = (CustomBlockEntity)tileEntity;
                te.dir = msg.dir;
                te.offset[0] = msg.offsetX;
                te.offset[1] = msg.offsetY;
                te.offset[2] = msg.offsetZ;
                te.retint = msg.retint;
                te.showHint = msg.showHint;
                te.color[0] = msg.red;
                te.color[1] = msg.green;
                te.color[2] = msg.blue;
                te.displayState = msg.displayState;
                tileEntity.m_6596_();
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

