/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.entities;

import com.devbobcorn.nekoration.entities.ModEntityType;
import com.devbobcorn.nekoration.items.ModItems;
import com.devbobcorn.nekoration.network.ModPacketHandler;
import com.devbobcorn.nekoration.network.S2CUpdateWallpaperPart;
import com.devbobcorn.nekoration.utils.TagTypes;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;

public class WallPaperEntity
extends HangingEntity
implements IEntityAdditionalSpawnData {
    @Nullable
    private DyeColor baseColor = DyeColor.WHITE;
    @Nullable
    private ListTag itemPatterns;
    private boolean receivedData = false;
    @Nullable
    private List<Pair<Holder<BannerPattern>, DyeColor>> patterns = null;
    private Part part = Part.FULL;

    protected WallPaperEntity(EntityType<WallPaperEntity> type, Level world) {
        super((EntityType)ModEntityType.WALLPAPER_TYPE.get(), world);
    }

    public WallPaperEntity(Level world, BlockPos pos, Direction dir, ItemStack stack, Part part) {
        super((EntityType)ModEntityType.WALLPAPER_TYPE.get(), world, pos);
        this.part = part;
        this.m_6022_(dir);
        this.fromItem(stack);
    }

    public WallPaperEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)ModEntityType.WALLPAPER_TYPE.get(), world);
    }

    public void setPart(Part part) {
        this.part = part;
    }

    public Part getPart() {
        return this.part;
    }

    @Nullable
    public static ListTag getPatterns(CompoundTag tag) {
        ListTag listnbt = null;
        if (tag.m_128425_("Patterns", (int)TagTypes.LIST_NBT_ID)) {
            listnbt = tag.m_128437_("Patterns", (int)TagTypes.COMPOUND_NBT_ID).m_6426_();
        }
        return listnbt;
    }

    @Nullable
    public static DyeColor getBaseColor(CompoundTag tag) {
        if (tag.m_128425_("Base", (int)TagTypes.INT_NBT_ID)) {
            return DyeColor.m_41053_((int)tag.m_128451_("Base"));
        }
        return DyeColor.WHITE;
    }

    public DyeColor getBaseColor() {
        return this.baseColor;
    }

    public ItemStack getItem() {
        ItemStack itemstack = new ItemStack((ItemLike)ModItems.WALLPAPER.get());
        CompoundTag tag = itemstack.m_41698_("BlockEntityTag");
        if (this.itemPatterns != null && !this.itemPatterns.isEmpty()) {
            tag.m_128365_("Patterns", (Tag)this.itemPatterns.m_6426_());
            tag.m_128405_("Base", this.baseColor.m_41060_());
        } else if (this.baseColor != DyeColor.WHITE) {
            tag.m_128405_("Base", this.baseColor.m_41060_());
        }
        return itemstack;
    }

    public void fromItem(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null) {
            this.itemPatterns = WallPaperEntity.getPatterns(tag);
            this.baseColor = WallPaperEntity.getBaseColor(tag);
            this.patterns = null;
            this.receivedData = true;
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.part == Part.LOWER) {
            this.part = Part.UPPER;
        } else if (this.part == Part.UPPER) {
            this.part = Part.LOWER;
        }
        Level world = player.f_19853_;
        if (!world.f_46443_) {
            S2CUpdateWallpaperPart packet = new S2CUpdateWallpaperPart(this.m_19879_(), this.part.id);
            ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128344_("Facing", (byte)this.f_31699_.m_122416_());
        tag.m_128344_("Part", this.part.id);
        tag.m_128405_("Base", this.baseColor.m_41060_());
        if (this.itemPatterns != null) {
            tag.m_128365_("Patterns", (Tag)this.itemPatterns);
        }
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        this.f_31699_ = Direction.m_122407_((int)tag.m_128445_("Facing"));
        this.part = Part.fromId(tag.m_128445_("Part"));
        this.baseColor = tag.m_128425_("Base", (int)TagTypes.INT_NBT_ID) ? DyeColor.m_41053_((int)tag.m_128451_("Base")) : DyeColor.WHITE;
        if (tag.m_128425_("Patterns", (int)TagTypes.LIST_NBT_ID)) {
            this.itemPatterns = tag.m_128437_("Patterns", (int)TagTypes.COMPOUND_NBT_ID);
            this.patterns = null;
            this.receivedData = true;
        }
        super.m_7378_(tag);
        this.m_6022_(this.f_31699_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<Holder<BannerPattern>, DyeColor>> getPatterns() {
        if (this.patterns == null && this.receivedData) {
            this.patterns = WallPaperEntity.createPatterns(this.baseColor, this.itemPatterns);
        }
        return this.patterns;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<Pair<Holder<BannerPattern>, DyeColor>> createPatterns(DyeColor baseColor, @Nullable ListTag tag) {
        ArrayList list = Lists.newArrayList();
        list.add(Pair.of((Object)Registry.f_235736_.m_206081_(BannerPatterns.f_222726_), (Object)baseColor));
        if (tag != null) {
            for (int i = 0; i < tag.size(); ++i) {
                CompoundTag compoundnbt = tag.m_128728_(i);
                Holder holder = BannerPattern.m_222700_((String)compoundnbt.m_128461_("Pattern"));
                if (holder == null) continue;
                int j = compoundnbt.m_128451_("Color");
                list.add(Pair.of((Object)holder, (Object)DyeColor.m_41053_((int)j)));
            }
        }
        return list;
    }

    public int m_7076_() {
        return 14;
    }

    public int m_7068_() {
        return this.part == Part.FULL ? 32 : 16;
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.getItem();
    }

    public void m_5553_(Entity entity) {
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
            if (entity instanceof Player) {
                Player playerentity = (Player)entity;
                if (playerentity.m_150110_().f_35937_) {
                    return;
                }
            }
            this.m_19983_(this.getItem());
        }
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_11714_, 1.0f, 1.0f);
    }

    public Packet<?> m_5654_() {
        Packet packet = NetworkHooks.getEntitySpawningPacket((Entity)this);
        return packet;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeByte((int)this.part.id);
        buffer.writeDouble(this.m_20182_().f_82479_);
        buffer.writeDouble(this.m_20182_().f_82480_);
        buffer.writeDouble(this.m_20182_().f_82481_);
        buffer.m_130064_(this.m_20183_());
        buffer.writeByte(this.f_31699_.m_122416_());
        buffer.writeDouble(this.m_20191_().f_82288_);
        buffer.writeDouble(this.m_20191_().f_82289_);
        buffer.writeDouble(this.m_20191_().f_82290_);
        buffer.writeDouble(this.m_20191_().f_82291_);
        buffer.writeDouble(this.m_20191_().f_82292_);
        buffer.writeDouble(this.m_20191_().f_82293_);
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Base", this.baseColor.m_41060_());
        if (this.itemPatterns != null) {
            tag.m_128365_("Patterns", (Tag)this.itemPatterns);
        }
        buffer.m_130079_(tag);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.part = Part.fromId(additionalData.readByte());
        this.m_20343_(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        this.f_31698_ = additionalData.m_130135_();
        byte dir = additionalData.readByte();
        this.f_31699_ = Direction.m_122407_((int)dir);
        this.m_146922_(this.f_31699_.m_122416_() * 90);
        this.f_19859_ = this.m_146908_();
        this.m_20011_(new AABB(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble()));
        CompoundTag tag = additionalData.m_130260_();
        if (tag.m_128425_("Base", (int)TagTypes.INT_NBT_ID)) {
            this.baseColor = DyeColor.m_41053_((int)tag.m_128451_("Base"));
        }
        if (tag.m_128425_("Patterns", (int)TagTypes.LIST_NBT_ID)) {
            this.itemPatterns = tag.m_128437_("Patterns", (int)TagTypes.COMPOUND_NBT_ID);
            this.patterns = null;
            this.receivedData = true;
        }
    }

    public static enum Part {
        UPPER(0, "upper"),
        LOWER(1, "lower"),
        FULL(2, "full");

        public final byte id;
        public final String name;

        private Part(byte id, String name) {
            this.id = id;
            this.name = name;
        }

        public static Part fromId(byte id) {
            for (Part p : Part.values()) {
                if (p.id != id) continue;
                return p;
            }
            return FULL;
        }
    }
}

