/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.entities;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.client.ClientHelper;
import com.devbobcorn.nekoration.entities.ModEntityType;
import com.devbobcorn.nekoration.entities.PaintingData;
import com.devbobcorn.nekoration.items.ModItems;
import com.devbobcorn.nekoration.items.PaintingItem;
import com.devbobcorn.nekoration.utils.TagTypes;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class PaintingEntity
extends HangingEntity
implements IEntityAdditionalSpawnData {
    public PaintingData data;

    protected PaintingEntity(EntityType<PaintingEntity> type, Level world) {
        super((EntityType)ModEntityType.PAINTING_TYPE.get(), world);
    }

    public PaintingEntity(Level world, BlockPos pos, Direction dir, short w, short h) {
        super((EntityType)ModEntityType.PAINTING_TYPE.get(), world, pos);
        this.m_6022_(dir);
        this.data = new PaintingData(w, h, false, this.f_19820_);
    }

    public PaintingEntity(Level world, BlockPos pos, Direction dir, short w, short h, UUID existingId) {
        super((EntityType)ModEntityType.PAINTING_TYPE.get(), world, pos);
        this.m_6022_(dir);
        this.data = new PaintingData(w, h, false, existingId);
    }

    public PaintingEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)ModEntityType.PAINTING_TYPE.get(), world);
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128344_("Facing", (byte)this.f_31699_.m_122416_());
        PaintingData.writeTo(this.data, tag);
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        this.f_31699_ = Direction.m_122407_((int)tag.m_128445_("Facing"));
        this.data = PaintingData.readFrom(tag, this.f_19820_);
        super.m_7378_(tag);
        this.m_6022_(this.f_31699_);
    }

    public int m_7076_() {
        return this.data == null ? 1 : (int)this.data.getWidth();
    }

    public int m_7068_() {
        return this.data == null ? 1 : (int)this.data.getHeight();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Level world = player.f_19853_;
        if (world.f_46443_) {
            if (stack.m_41720_() == ModItems.PALETTE.get()) {
                CompoundTag nbt = stack.m_41783_();
                if (nbt != null && nbt.m_128425_("active", (int)TagTypes.BYTE_NBT_ID)) {
                    byte a = nbt.m_128445_("active");
                    int[] c = nbt.m_128465_("colors");
                    Color[] col = new Color[6];
                    for (int i = 0; i < 6; ++i) {
                        col[i] = new Color(NekoColors.getRed(c[i]), NekoColors.getGreen(c[i]), NekoColors.getBlue(c[i]));
                    }
                    DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHelper.showPaintingScreen(this.m_19879_(), a, col));
                } else {
                    ClientHelper.showPaintingScreen(this.m_19879_());
                }
            } else if (stack.m_41720_() != ModItems.PAINTING.get()) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.nekoration.message.paint_with_palette"), true);
            }
        } else if (stack.m_41720_() == ModItems.PAINTING.get() && PaintingItem.getType(stack) == PaintingItem.Type.BLANK.id) {
            PaintingItem.setLink(stack, (short)(this.m_7076_() / 16), (short)(this.m_7068_() / 16), this.data.getUUID(), this.m_19879_());
        }
        return InteractionResult.SUCCESS;
    }

    public ItemStack getPickItem() {
        ItemStack result = new ItemStack((ItemLike)ModItems.PAINTING.get());
        if (this.m_7076_() <= 96 && this.m_7068_() <= 96) {
            PaintingItem.setContent(result, (short)(this.m_7076_() / 16), (short)(this.m_7068_() / 16), this.data.getUUID(), this.data.getPixels());
        } else {
            PaintingItem.setLink(result, (short)(this.m_7076_() / 16), (short)(this.m_7068_() / 16), this.data.getUUID(), this.m_19879_());
        }
        return result;
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.getPickItem();
    }

    public ItemStack getDropItem() {
        ItemStack result = new ItemStack((ItemLike)ModItems.PAINTING.get());
        if (this.m_7076_() <= 96 && this.m_7068_() <= 96) {
            PaintingItem.setContent(result, (short)(this.m_7076_() / 16), (short)(this.m_7068_() / 16), this.data.getUUID(), this.data.getPixels());
        } else {
            PaintingItem.setSize(result, (short)(this.m_7076_() / 16), (short)(this.m_7068_() / 16));
        }
        return result;
    }

    public void m_5553_(Entity entity) {
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            if (entity instanceof Player) {
                Player playerentity = (Player)entity;
                if (playerentity.m_150110_().f_35937_) {
                    return;
                }
            }
            this.m_19983_(this.getDropItem());
        }
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    public Packet<?> m_5654_() {
        Packet packet = NetworkHooks.getEntitySpawningPacket((Entity)this);
        return packet;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeShort((int)this.data.getWidth());
        buffer.writeShort((int)this.data.getHeight());
        buffer.m_130089_(this.data.getPixels());
        buffer.m_130077_(this.data.getUUID());
        buffer.writeDouble(this.m_20182_().f_82479_);
        buffer.writeDouble(this.m_20182_().f_82480_);
        buffer.writeDouble(this.m_20182_().f_82481_);
        buffer.m_130064_(this.m_20183_());
        buffer.writeByte(this.f_31699_.m_122416_());
        buffer.writeDouble(this.m_20191_().f_82288_);
        buffer.writeDouble(this.m_20191_().f_82289_);
        buffer.writeDouble(this.m_20191_().f_82290_);
        buffer.writeDouble(this.m_20191_().f_82291_);
        buffer.writeDouble(this.m_20191_().f_82292_);
        buffer.writeDouble(this.m_20191_().f_82293_);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.data = new PaintingData(additionalData.readShort(), additionalData.readShort(), additionalData.m_130100_(), true, additionalData.m_130259_());
        this.m_20343_(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        this.f_31698_ = additionalData.m_130135_();
        byte dir = additionalData.readByte();
        this.f_31699_ = Direction.m_122407_((int)dir);
        this.m_146922_(this.f_31699_.m_122416_() * 90);
        this.f_19859_ = this.m_146908_();
        this.m_20011_(new AABB(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble()));
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.f_19853_.f_46443_) {
            this.data.clearCache(this.data.getPaintingHash());
        }
    }
}

