/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.rendering.entities;

import com.devbobcorn.nekoration.client.event.ClientModEventSubscriber;
import com.devbobcorn.nekoration.entities.WallPaperEntity;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;

public class WallPaperRenderer
extends EntityRenderer<WallPaperEntity> {
    public final ModelPart paperFull;
    public final ModelPart paperUpper;
    public final ModelPart paperLower;

    public WallPaperRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart modelpart = ctx.m_174023_(ClientModEventSubscriber.WALLPAPER);
        this.paperFull = modelpart.m_171324_("full");
        this.paperUpper = modelpart.m_171324_("upper");
        this.paperLower = modelpart.m_171324_("lower");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("upper", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-10.0f, 0.0f, 0.0f, 20.0f, 20.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)-0.5f));
        partdefinition.m_171599_("lower", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171481_(-10.0f, 0.0f, 0.0f, 20.0f, 20.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)-0.5f));
        partdefinition.m_171599_("full", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-10.0f, 0.0f, 0.0f, 20.0f, 40.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)-20.0f, (float)-0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart getPaper(WallPaperEntity.Part part) {
        switch (part) {
            case FULL: {
                return this.paperFull;
            }
            case LOWER: {
                return this.paperLower;
            }
        }
        return this.paperUpper;
    }

    public void render(WallPaperEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffers, int packedLight) {
        stack.m_85836_();
        stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotation));
        this.renderWallPaper(stack, buffers, entity, entity.m_7068_(), packedLight);
        stack.m_85849_();
        super.m_7392_((Entity)entity, rotation, partialTicks, stack, buffers, packedLight);
    }

    public ResourceLocation getTextureLocation(WallPaperEntity entity) {
        return null;
    }

    public static List<Pair<Holder<BannerPattern>, DyeColor>> getBlankPattern(DyeColor base) {
        ArrayList list = Lists.newArrayList();
        list.add(Pair.of((Object)Registry.f_235736_.m_206081_(BannerPatterns.f_222726_), (Object)base));
        return list;
    }

    private void renderWallPaper(PoseStack stack, MultiBufferSource buffers, WallPaperEntity entity, int height, int light) {
        float sc = 0.8f;
        stack.m_85841_(sc, sc, sc);
        stack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        BannerRenderer.m_112065_((PoseStack)stack, (MultiBufferSource)buffers, (int)light, (int)0xFFFFFF, (ModelPart)this.getPaper(entity.getPart()), (Material)ModelBakery.f_119224_, (boolean)true, entity.getPatterns() == null ? WallPaperRenderer.getBlankPattern(entity.getBaseColor()) : entity.getPatterns());
    }
}

