/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.rendering.blockentities;

import com.devbobcorn.nekoration.blocks.ItemDisplayBlock;
import com.devbobcorn.nekoration.blocks.entities.ItemDisplayBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;

public class CupboardRenderer
implements BlockEntityRenderer<ItemDisplayBlockEntity> {
    Font font;

    public CupboardRenderer(BlockEntityRendererProvider.Context ctx) {
        this.font = ctx.m_173586_();
    }

    public void render(ItemDisplayBlockEntity tileEntity, float partialTicks, PoseStack stack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        stack.m_85836_();
        if (tileEntity.wallShelf) {
            this.renderShelfItems(tileEntity, stack, buffers, combinedLight);
        } else {
            this.renderCabinetItems(tileEntity, stack, buffers, combinedLight);
        }
        stack.m_85849_();
    }

    private void renderShelfItems(ItemDisplayBlockEntity tileEntity, PoseStack stack, MultiBufferSource buffers, int combinedLight) {
        stack.m_85837_(0.5, 0.5, 0.5);
        stack.m_85845_(Vector3f.f_122225_.m_122240_((float)(-((Direction)tileEntity.m_58900_().m_61143_((Property)ItemDisplayBlock.FACING)).m_122416_()) * 90.0f));
        float sc = 0.5f;
        stack.m_85841_(sc, sc, sc);
        stack.m_85845_(Vector3f.f_122223_.m_122240_(-10.0f));
        int rand = (int)tileEntity.m_58899_().m_121878_();
        stack.m_85837_(-1.35, 0.2, -0.5);
        for (int i = 0; i < 4; ++i) {
            stack.m_85837_(0.55, 0.0, -0.0);
            Minecraft.m_91087_().m_91291_().m_174269_(tileEntity.renderItems[i], ItemTransforms.TransformType.GROUND, combinedLight, OverlayTexture.f_118083_, stack, buffers, rand + i + 1);
        }
    }

    private void renderCabinetItems(ItemDisplayBlockEntity tileEntity, PoseStack stack, MultiBufferSource buffers, int combinedLight) {
        stack.m_85837_(0.5, 0.5, 0.5);
        stack.m_85845_(Vector3f.f_122225_.m_122240_((float)(-((Direction)tileEntity.m_58900_().m_61143_((Property)ItemDisplayBlock.FACING)).m_122416_()) * 90.0f));
        float sc = 0.5f;
        stack.m_85841_(sc, sc, sc);
        stack.m_85845_(Vector3f.f_122223_.m_122240_(-10.0f));
        int rand = (int)tileEntity.m_58899_().m_121878_();
        stack.m_85837_(-0.4, 0.2, -0.5);
        Minecraft.m_91087_().m_91291_().m_174269_(tileEntity.renderItems[0], ItemTransforms.TransformType.GROUND, combinedLight, OverlayTexture.f_118083_, stack, buffers, rand + 1);
        stack.m_85837_(0.8, 0.0, 0.0);
        Minecraft.m_91087_().m_91291_().m_174269_(tileEntity.renderItems[1], ItemTransforms.TransformType.GROUND, combinedLight, OverlayTexture.f_118083_, stack, buffers, rand + 2);
        stack.m_85837_(0.0, -0.7, -0.2);
        Minecraft.m_91087_().m_91291_().m_174269_(tileEntity.renderItems[3], ItemTransforms.TransformType.GROUND, combinedLight, OverlayTexture.f_118083_, stack, buffers, rand + 3);
        stack.m_85837_(-0.8, 0.0, 0.0);
        Minecraft.m_91087_().m_91291_().m_174269_(tileEntity.renderItems[2], ItemTransforms.TransformType.GROUND, combinedLight, OverlayTexture.f_118083_, stack, buffers, rand + 4);
    }

    public boolean shouldRenderOffScreen(ItemDisplayBlockEntity BlockEntity2) {
        return false;
    }
}

